#!/bin/sh

# Run from main directory: `sh scripts/train.sh`

# CELEBAxCELEBA denoising (ODE)
python train_dpi.py \
    --score_model_config score_configs/default_ncsnpp_config.py \
    --config dpi_configs/default_config.py \
    --workdir dpi/Denoising_CELEBAxCELEBA_antialias_ODE \
    --config.prob_flow.score_model_dir score_checkpoints/CELEBA_32_ncsnpp_nf=64_vpsde_betamin=0.1_betamax=20.0_notcentered/checkpoints/checkpoint_800000 \
    --config.data.dataset CELEBA \
    --config.data.image_size 32 \
    --config.data.num_channels 3 \
    --config.data.shuffle_seed 1 \
    --config.likelihood.likelihood Denoising \
    --config.likelihood.noise_scale 0.2 \
    --config.training.batch_size 64 \
    --config.training.n_iters 1000000 \
    --config.training.snapshot_freq 100 \
    --config.training.log_freq 10 \
    --config.optim.learning_rate 2e-4 \
    --config.optim.grad_clip 1. \
    --config.optim.prior ode \
    --config.optim.warmup 0 \
    --config.prob_flow.n_trace_estimates 16 \
    --score_model_config.training.sde vpsde \
    --score_model_config.model.beta_max 20
