#!/bin/sh

python train_dpi_mri.py \
    --image 0 \
    --data_path test_data/fastmri_test.npy \
    --score_model_config score_configs/default_ncsnpp_config.py \
    --config dpi_configs/default_config.py \
    --workdir mri_results/dpi_v2 \
    --config.prob_flow.score_model_dir score_checkpoints/fastMRI_64_ncsnpp_nf=64_vpsde_betamin=0.1_betamax=10.0_notcentered/checkpoints \
    --config.data.dataset fastMRI \
    --config.data.image_size 64 \
    --config.data.num_channels 1 \
    --config.likelihood.likelihood MRI \
    --config.likelihood.mri_accel 8 \
    --config.training.batch_size 128 \
    --config.training.n_iters 500000 \
    --config.training.snapshot_freq 10000 \
    --config.training.check_convergence \
    --config.training.convergence_patience 2 \
    --config.training.convergence_thresh 0.005 \
    --config.optim.learning_rate 1e-5 \
    --config.optim.grad_clip 2e-4 \
    --config.optim.adam_eps 1e-8 \
    --config.optim.warmup 0 \
    --config.optim.prior dsm \
    --config.optim.dsm_nt 1 \
    --config.model.n_flow 32 \
    --score_model_config.training.sde vpsde \
    --score_model_config.model.beta_max 10
