

import os
from tensorpack import ScheduledHyperParamSetter


def parse_config(config_file):
  if not os.path.isfile(config_file):
    raise FileNotFoundError("File %s don't exist" % config_file)
  with open(config_file, 'r') as f:
    content = f.read()
  __locals = {}
  exec("config = %s" % content, __locals)
  config = __locals['config']
  return config


def get_learning_rate_setter(config):
  callbacks = []
  # TODO Warmup
  if config['warmup']:
    warmup_lr = config['warmup_lr']
    warmup_epoch = config['warmup_epoch']

  t = config['type']
  base_lr = config['learning_rate']
  if t == 'step':
    callbacks.append(ScheduledHyperParamSetter(
      'learning_rate', config['steps']))

  else:
    raise ValueError("Learning rate scheduler %s not supported" % t)

  return callbacks


