import requests, subprocess, time, os
from datetime import datetime

# Google Cloud SDK 경로 설정
GCLOUD_PATH = os.environ.get('GCLOUD_PATH', 'YOUR gcloud path')

PROJECT_ID = "your_project_name"
BUCKET = "your_bucket_name"

def veo2(prompt):
    #token = subprocess.run(["cmd", "/c", "gcloud", "auth", "print-access-token"], capture_output=True, text=True).stdout.strip()
    token = subprocess.run(
    [GCLOUD_PATH, "auth", "print-access-token"],
    capture_output=True, text=True).stdout.strip()
    base_url = f"https://us-central1-aiplatform.googleapis.com/v1/projects/{PROJECT_ID}/locations/us-central1/publishers/google/models/veo-2.0-generate-001"
    headers = {"Authorization": f"Bearer {token}", "Content-Type": "application/json"}
    timestamp = datetime.now().strftime("%Y%m%d_%H%M%S")
    
    # Start generation
    resp = requests.post(f"{base_url}:predictLongRunning", headers=headers, json={
        "instances": [{"prompt": prompt}],
        "parameters": {"storageUri": f"gs://{BUCKET}/veo2_videos/{timestamp}/", "sampleCount": 1, "durationSeconds": 5, "enhancePrompt": False}
    })
    
    if resp.status_code != 200: return f"Error: {resp.text}"
    op_id = resp.json()["name"].split("/")[-1]
    
    # Wait for completion
    for i in range(30):
        time.sleep(20)
        status = requests.post(f"{base_url}:fetchPredictOperation", headers=headers, json={
            "operationName": f"projects/{PROJECT_ID}/locations/us-central1/publishers/google/models/veo-2.0-generate-001/operations/{op_id}"
        }).json()
        
        if status.get("done"):
            if "error" in status: 
                return f"Failed: {status['error']}"
            
            # Download video
            gcs_uri = status["response"]["videos"][0]["gcsUri"]
            https_url = gcs_uri.replace("gs://", "https://storage.googleapis.com/")
            
            os.makedirs("folder_name", exist_ok=True)
            filename = f"folder_name/veo2_{timestamp}.mp4"
            
            with open(filename, 'wb') as f:
                f.write(requests.get(https_url, headers=headers).content)
            
            return filename
    
    return "Timeout"
