from .missing import simulate_nan
from ..utils import train_test_split


def simulate_missing(cfg, transform_set, drop_observed=False):

    def func(dataframe):
        return simulate_nan(cfg, transform_set, dataframe, drop_observed).reset_index(drop=True)

    return func


def in_sample_missing(cfg, transform_set, drop_observed=False):

    def func(dataframe):
        in_sample, _ = train_test_split(dataframe, ratio=0.7, random_state=cfg.missing.random_state)
        return simulate_nan(cfg, transform_set, in_sample, drop_observed).reset_index(drop=True)

    return func


def out_of_sample_missing(cfg, transform_set, drop_observed=False):
    cfg = cfg.copy()

    def func(dataframe):
        _, out_of_sample = train_test_split(dataframe, ratio=0.7, random_state=cfg.missing.random_state)
        return simulate_nan(cfg, transform_set, out_of_sample, drop_observed).reset_index(drop=True)

    return func
