from sklearn.preprocessing import QuantileTransformer, StandardScaler, MinMaxScaler, FunctionTransformer

__all__ = ['SCALERS', 'DEFAULT_SCALERS']

SCALERS = dict(
    uniform=lambda x: QuantileTransformer(output_distribution='uniform',
                                          n_quantiles=max(min(len(x), 4096), 10),
                                          random_state=42),
    normal=lambda x: QuantileTransformer(output_distribution='normal',
                                         n_quantiles=max(min(len(x), 4096), 10),
                                         random_state=42),
    tabsyn=lambda x: QuantileTransformer(output_distribution='normal',
                                         n_quantiles=max(min(len(x) // 30, 1000), 10),
                                         random_state=42, subsample=int(1e9)),
    standard=lambda x: StandardScaler(),
    minmax=lambda x: MinMaxScaler(feature_range=(0, 1)),
    none=lambda x: FunctionTransformer()
)

DEFAULT_SCALERS = dict(
    standard=lambda x: StandardScaler(),
    minmax=lambda x: MinMaxScaler(feature_range=(0, 1)),
    none=lambda x: FunctionTransformer()
)
