import inspect
from functools import wraps


def create_hook(func, hook):
    @wraps(func)
    def wrapper(*args, **kwargs):
        hook(*args, **kwargs)
        return func(*args, **kwargs)

    return wrapper


def create_post_hook(func, hook):
    @wraps(func)
    def wrapper(*args, **kwargs):
        result = func(*args, **kwargs)
        hook(*args, **kwargs)
        return result

    return wrapper


def create_postprocess(func, hook):
    @wraps(func)
    def wrapper(*args, **kwargs):
        result = func(*args, **kwargs)
        result = hook(result)
        return result

    return wrapper


def get_kwargs(**kwargs):
    frame = inspect.currentframe().f_back
    keys, _, _, values = inspect.getargvalues(frame)
    for key in keys:
        if key != 'self':
            kwargs[key] = values[key]
    return kwargs
