import itertools, subprocess, sys

datasets = ['gesture','housing','letter','magic','bean','adult',
            'default','shoppers','news']
seeds = range(5)

extra_args = sys.argv[1:]          # 스크립트 뒤에 오는 모든 토큰

for sd, ds in itertools.product(seeds, datasets):
    print(f"▶ dataset={ds} seed={sd}")
    cmd = [
        "python", "run.py",
        f"dataset=privacy/{ds}",
        f"seed={sd}",
        *extra_args,               # 추가 인자 주입
    ]
    result = subprocess.run(cmd)
    if result.returncode != 0:     # 에러 감지 시 즉시 중단
        sys.stderr.write(f"❌ Failed on {ds} (seed={sd})\n")

print("✅ All Done")
