import pickle as pk
import os
from pathlib import Path

def create_file_path(list_to_name: list, list_path: list) -> str:
    filename = "_".join([str(val) for val in list_to_name]) + '.pk'
    path = "/".join(list_path)
    Path(path).mkdir(parents=True, exist_ok=True)
    file_path = os.path.join(path, filename)
    return file_path


def store_results(store_per_trial, cfg, file_path):
    dict_store = {'cfg': cfg, 'store_per_trial': store_per_trial}
    with open(file_path, 'wb') as f:
        pk.dump(dict_store, f)
