# Supplementary Materials

This archive contains the dataset and code accompanying the NeurIPS 2025 workshop paper *SubtaskEval: Benchmarking LLMs on Competitive Programming Subtasks* by Samik Goyal. The code is licensed under the MIT license, and the dataset is licensed under the CC-BY-SA license.

It includes:

* **`dataset.jsonl`** – the dataset in JSON Lines format.
* **`fetch_results.py`** – a script to fetch submissions for a given user.
* **`submit.py`** – a script to automatically submit solutions to *qoj.ac* using a dataset.

---

## Requirements

The code requires Python **3.8+** and the following Python packages:

```bash
pip install playwright datasets
python -m playwright install
```

Other standard-library modules used:

* `argparse`, `sys`, `time`, `json`, `re`, `traceback`, `typing`, `urllib.parse`

---

## Dataset

**File:** `dataset.jsonl`

* Format: JSON Lines (one JSON object per line).
* Example schema:

```json
{
  "name": "Foehn Phenomena",
  "link": "https://qoj.ac/contest/403/problem/3141",
  "year": 2017,
  "source": "JOIFR",
  "category": "batch",
  "subtask_count": 3,
  "problem_statement_md": "...",
  "io_and_constraints": "...",
  "samples_with_explanations": "...",
  "subtasks": "..."
}
```

---

## Scripts

### 1. `fetch_results.py`

Run directly:

```bash
python fetch_results.py
```

* A Chromium window will open.
* Log in to *qoj.ac* when prompted.
* Enter the username whose submissions you want to fetch.
* The script will output a file:

```
{user_id}-submissions.parquet
```

with the following columns:

* `link` – problem link
* `verdict` – submission result
* `submission_link` – direct link to submission
* `subtask_result_1 ... subtask_result_50` – per-subtask results

---

### 2. `submit.py`

This script submits solutions to *qoj.ac* from a dataset.
The dataset must contain at least:

* `link` column – problem URL
* `code` column – solution source code

Run as:

```bash
python submit.py --dataset "path/to/dataset.parquet"
```

* A Chromium window will open.
* Log in to *qoj.ac* when prompted.
* The script will then iterate over dataset rows and submit solutions automatically.

---

Note: Both scripts keep the browser open until you press Enter, so you can verify the results.

---

## Tested On

- `python==3.12.7`
- `playwright==1.54.0`
- `datasets==4.0.0`
- Operating System: Windows 11 (Anaconda environment)
