# TISR Attack - Text-Image Segmentation and Reassembly

Implementation of the TISR attack method from the paper "TISR: Breaking Vision–Language Models via Text–Image Segmentation and Reassembly".

## Attack Pipeline

TISR is a black-box jailbreak attack against Large Vision-Language Models (LVLMs) that disperses harmful semantic fragments across visual modality and uses text-based role-playing to guide reassembly.

### Stage 1: Identity Definition
**File**: `id_generate.py`
- Generates the most relevant malicious identity based on harmful text
- Matches appropriate role characteristics for each attack scenario
- Creates disguised righteous intent prompts

### Stage 2: Text-Image Segmentation and Reassembly (TIPIR Algorithm)
**Files**: `TIPIR.py`, `shuffle_text.py`
- **Text Segmentation**: Splits harmful text into minimal semantic units at character level
- **Image Segmentation**: Divides original image into 16 labeled blocks
- **Reassembly**: Uses TIPIR algorithm to recombine text and image fragments with maximum spatial separation
- Creates 8×8 grid with 48 text blocks across 4 isolated regions and 16 image blocks

### Stage 3: Attack Prompt Construction
**File**: `attack.py`
- Integrates role information with encoded multimodal inputs
- Constructs prompts that appear harmless on surface but contain deep malicious intent
- Uses role-playing narratives to guide semantic reconstruction

### Stage 4: Model Attack
**File**: `attack.py`
- Sends constructed attack prompts to target LVLM
- Evaluates harmfulness of model responses
- Measures attack success rates and toxicity scores

## Usage

```bash
cd attack
python attack.py --dirname 04-Physical_Harm
```

## Core Files

- `attack.py` - Main execution pipeline
- `id_generate.py` - Identity generation 
- `TIPIR.py` - Text-image segmentation and reassembly algorithm
- `shuffle_text.py` - Character-level text processing
- `prompts.py` - Prompt templates
