from reportlab.lib.pagesizes import letter
from reportlab.pdfgen import canvas
from reportlab.lib import colors

fontsize = 13

def generate_code_figure(output_path):
    # Create a list of code lines with line numbers
    code_lines = [
        "# Map task0 to GPU and task1 to CPU.",
        "Task task0 GPU;",
        "Task task1 CPU;",
        "# Place data from task2 to GPU FrameBuffer.",
        "Region task2 * GPU FBMEM",
        "# Place certain data onto GPU ZeroCopy.",
        "Region * ghost_region GPU ZCMEM",
        "# Data layout is C order and SOA.",
        "Layout * * * C_order SOA",
        "",
        "# Collect all data used by task3.",
        "GarbageCollect task3 *",
        "# Ensure only 1 task3 is active at once.",
        "Backpressure task3 1",
        "# Define a block mapping strategy",
        "",
        "def block4d(Task task):",
        "    # ispace represents iteration space.",
        "    is = task.ispace",
        "    # ipoint is an iteration point.",
        "    ip = task.ipoint",
        "    # Get all GPUs as a grid.",
        "    machine = Machine(GPU)",
        "    # Apply primitives twice.",
        "    m3d = machine.decompose(0, is)",
        "    m4d = m3d.decompose(2, is / m3d[:-1])",
        "    # Project the index point",
        "    upper = (ip[0] * m4d[0] / is[0],",
        "             ip[1] * m4d[1] / is[1])",
        "    lower = (ip[0] % m4d[2],",
        "             ip[1] % m4d[3])",
        "    # Unpack two 2D tuples for indexing",
        "    return m4d[*upper, *lower]",
        "",
        "# Apply the block mapping strategy to task4.",
        "IndexTaskMap task4 block4d",
    ]

    # Estimate the size based on the number of lines
    line_height = 22
    line_count = len(code_lines)
    content_height = line_count * line_height + 20  # Height for all lines
    content_width = 380  # Width of the content
    print("example", content_height, content_width)

    # Create a canvas with a custom size matching the content size
    c = canvas.Canvas(output_path, pagesize=(content_width, content_height))

    # Define positions for line numbers and code
    margin_left = 30
    line_number_x = margin_left - 25
    code_x = margin_left

    # Initial vertical position
    y_position = content_height - 20

    # Define colors for comments and special keywords
    comment_color = colors.HexColor("#6a737d")  # Gray for comments
    keyword_color = colors.HexColor("#d73a49")  # Red for Python keywords
    black_color = colors.black  # Default color for other parts
    special_keywords = ["Task", "Region", "Layout", "Backpressure", "GarbageCollect",
                        "IndexTaskMap", "SingleTaskMap", "Machine", "def"]

    # Set the font for code and line numbers
    c.setFont("Courier", fontsize)

    # Loop through each line of code and print it with line numbers
    for i, line in enumerate(code_lines):
        # Draw the line number
        c.setFont("Courier", fontsize)
        c.setFillColor(black_color)
        c.drawString(line_number_x, y_position, f"{i + 1}")

        # Check if the line is a comment
        if line.strip().startswith("#"):
            # Entire line is a comment, so set the comment color
            c.setFillColor(comment_color)
            c.drawString(code_x, y_position, line)  # Draw the entire line in comment color
        else:
            # Highlight special keywords in the line
            x_position = code_x
            for word in line.split(" "):
                # Check for keywords only if the line is not a comment
                if word.strip() in special_keywords:
                    c.setFillColor(keyword_color)
                else:
                    c.setFillColor(black_color)

                # Draw each word
                c.drawString(x_position, y_position, word)
                x_position += c.stringWidth(word + " ", "Courier", fontsize)  # Add space after each word

        # Move to the next line
        y_position -= line_height


    # Save the PDF with no extra white space
    c.save()

# Generate the PDF
output_pdf = "example.pdf"
generate_code_figure(output_pdf)
