# Mapping symbols to LaTeX
symbol_mapping = {
    'c': '--',            # Compiler error
    'f': r'\xmark',       # Test failure
    'p': r'\(\checkmark\)' # Test pass
}

# Define statuses
statuses = {
    'C++ (single trial)':     ['f', 'c', 'c', 'f', 'c', 'c', 'f', 'f', 'c', 'c'],
    'C++ (multiple trials w/ feedback)':  ['f', 'c', 'c', 'f', 'f', 'f', 'f', 'f', 'f', 'f'],
    'DSL (single trial)':     ['p', 'p', 'p', 'p', 'p', 'c', 'p', 'p', 'p', 'c'] # 5:```plaintext not removed;  9: mgpu not defined
}

# Function to generate the LaTeX table
def generate_latex_table(statuses, symbol_mapping):
    table = "\\hline\n"
    # First row of the header with Code Generation Target, Mapping Strategy, and Success Rate
    table += "\\multirow{2}{*}{Code Generation Target} & \\multicolumn{10}{c|}{Mapping Strategy} & \\multirow{2}{*}{Success Rate} \\\\\n"
    # # Line after the first row
    # table += "\\cline{2-11}\n"
    # Second row with test numbers (1-10)
    table += " & 1 & 2 & 3 & 4 & 5 & 6 & 7 & 8 & 9 & 10 & \\\\\n"
    table += "\\hline\n"
    
    for strategy, results in statuses.items():
        # Generate LaTeX row
        row = f"{strategy} & " + " & ".join(symbol_mapping[res] for res in results)
        
        # Calculate success rate (pass count / total count * 100)
        pass_count = results.count('p')
        success_rate = pass_count / len(results) * 100
        
        # Add success rate to the row
        row += f" & {int(success_rate)}\\% \\\\\n"
        table += row
    
    table += "\\hline\n"
    return table

# Generate and print LaTeX table
latex_table = generate_latex_table(statuses, symbol_mapping)
print(latex_table)
