import dspy
from dspy.teleprompt import LabeledFewShot
from llm_mapper.prompt_loader import dsl_documentation


class CustomMapper(dspy.Signature):
    """Generate the program for a memory mapper."""
    code_documentation = dspy.InputField(description="The documentation on how to write a mapper.")
    code_examples = dspy.InputField(description="Examples of mapper programs for other applications.",
                                    format=list)
    mapping_strategy = dspy.InputField(
        description="Produce a mapper program that uses this high-level mapping strategy.")
    starter_code = dspy.InputField(description="The starter code provided (feel free to modify if necessary).")
    conv_history = dspy.InputField(description="The conversation history.")
    instruction = dspy.InputField(description="The instruction for the model.")
    code = dspy.OutputField(description="The generated code.")


class Coder(dspy.Module):
    def __init__(self):
        super().__init__()
        self.prog = dspy.Predict(CustomMapper)

    def forward(self, code_documentation, code_examples, strategy, starter_code, conv_history, instruction):
        return self.prog(code_documentation=code_documentation, code_examples=code_examples, mapping_strategy=strategy,
                         starter_code=starter_code, conv_history=conv_history, instruction=instruction)


if __name__ == '__main__':
    coder = Coder()
