#!/bin/bash

# Get the list of unique log files from the grep output
log_files=$(grep -rl "error" result/ | sort | uniq)

# Loop through each log file
for log_file in $log_files; do
  # Get the full directory (including subdirectories) from the log file
  base_dir=$(dirname "$log_file")
  
  # Extract the mapping number from the log file name
  mapping_number=$(echo "$log_file" | grep -oP '(?<=log_conf0_mapping)\d+')
  
  # Construct the mapping file path dynamically based on the directory and mapping number
  mapping_file="$base_dir/mapping$mapping_number"
  
  # Check if the mapping file exists
  if [ -f "$mapping_file" ]; then
    # Display the content of the log file
    echo "Contents of $log_file:"
    cat "$log_file"
    
    echo -e "\n----------------------------------\n"
    echo -e "mapping$mapping_number is the following:\n"
    
    # Display the content of the corresponding mapping file
    cat "$mapping_file"
    
    echo -e "\n\n==========================\n\n"
  else
    echo -e "\n\nMapping file $mapping_file does not exist!\n\n"
  fi
done
