#!/bin/bash

run_for_application() {
  local app_name=$1
  local repeat_idx=$2
  if [ -z "$repeat_idx" ]; then
    for idx in {0..4}; do
      python3 opro.py "$app_name" "$idx"
    done
  else
    python3 opro.py "$app_name" "$repeat_idx"
  fi
}

app_name=$1
repeat_idx=$2

if [ -z "$app_name" ]; then
  echo "Error: Please specify an app name."
  exit 1
fi

# Handle the case where app_name is "all", "sci", or "gemm"
case $app_name in
  "all")
    run_for_application "circuit" "$repeat_idx"
    run_for_application "stencil" "$repeat_idx"
    run_for_application "pennant" "$repeat_idx"
    run_for_application "cannon" "$repeat_idx"
    run_for_application "pumma" "$repeat_idx"
    run_for_application "summa" "$repeat_idx"
    run_for_application "solomonik" "$repeat_idx"
    run_for_application "johnson" "$repeat_idx"
    run_for_application "cosma" "$repeat_idx"
    ;;
  "sci")
    run_for_application "circuit" "$repeat_idx"
    run_for_application "stencil" "$repeat_idx"
    run_for_application "pennant" "$repeat_idx"
    ;;
  "gemm")
    run_for_application "cannon" "$repeat_idx"
    run_for_application "pumma" "$repeat_idx"
    run_for_application "summa" "$repeat_idx"
    run_for_application "solomonik" "$repeat_idx"
    run_for_application "johnson" "$repeat_idx"
    run_for_application "cosma" "$repeat_idx"
    ;;
  *)
    run_for_application "$app_name" "$repeat_idx"
    ;;
esac
