**Installation**

- Install Poetry.
```
curl -sSL https://install.python-poetry.org | python3 -
```
- Install dependencies
```
poetry install
```
- Install Legion parallel programming framework

Please follow this guide: https://github.com/StanfordLegion/legion/tree/stable/language#installing-regent-on-a-supercomputer-via-setup_envpy

**Experiments in Section 5.1**


You need to first install and compile Legion framework.
Set the environment variable LG_RT_DIR to point to the Legion runtime directory.
Then you can run the following script
```
python3 llm_mapper/experiments/compilation_success.py
llm_mapper/experiments/summarize.py
```

**Experiments in Section 5.2, 5.3**


You need to first compile all the applications

Take circuit as an example:
```
cd app/circuit/
./compile src_trace/
```

Then get expert mapper performance for circuit
```
cd bin_trace
python3 run.py sapling --conf0 --mapping -1 --repeat 1
```

Then switch directory
```
cd llm_mapper/trace_mapper
```

- Trace-OptoPrime
```
./run_optimization.sh all
```

- Trace-OPRO
```
./run_opro.sh all
```

- Random Mapper
```
python llm_mapper/trace_mapper/randomMapper.py
```

**Experiments in Section 5.4**
```
cd llm_mapper/trace_mapper
./run_feedback.sh feed
```

**Summarize Experiment Results**
```
cd llm_mapper/trace_mapper
python3 report.py
```
