import json
import os
from os.path import join as pjoin
from textwrap import dedent

def get_current_file_directory():
    return os.path.dirname(os.path.abspath(__file__))

def load_text(path):
    with open(path, 'r') as f:
        return dedent(f.read())

def load_json(path):
    with open(path, 'r') as f:
        return json.load(f)

dsl_documentation = load_text(pjoin(get_current_file_directory(), 'prompts/dsl_doc.txt'))
cpp_documentation = load_text(pjoin(get_current_file_directory(), 'prompts/cpp_doc.txt'))
dsl_demo_programs = load_json(pjoin(get_current_file_directory(), 'prompts/demo_dsl_program.json'))
cpp_demo_programs = load_json(pjoin(get_current_file_directory(), 'prompts/demo_cpp_program.json'))