#!/bin/bash

# Define app groups
all_apps=("circuit" "stencil" "pennant" "cannon" "pumma" "summa" "solomonik" "johnson" "cosma")
gemm_apps=("cannon" "pumma" "summa" "solomonik" "johnson" "cosma")
sci_apps=("circuit" "stencil" "pennant")

# Function to clean files for a given directory and optional repeat number
clean_app() {
    dir=$1
    repeat_number=$2
    
    if [ -d "result/$dir" ]; then
        # If a repeat number is specified, clean only files matching that number
        if [ -n "$repeat_number" ]; then
            rm result/$dir/log_conf*_repeat${repeat_number}_mapping*.log
            rm result/$dir/${repeat_number}_mapping*
        else
            # Clean all files with digits in the repeat number slot
            rm result/$dir/log_conf*_repeat*[0-9]_mapping*.log
            rm result/$dir/*[0-9]_mapping*
        fi
        rm result/$dir/code*
        rm result/$dir/*pkl
        echo "Cleaned files in result/$dir directory."
    else
        echo "Directory result/$dir does not exist."
    fi
}

# Check if an argument is provided
if [ -z "$1" ]; then
    echo "Usage: ./clean.sh <directory|group> [repeat_number]"
    echo "Available groups: all, gemm, sci"
    exit 1
fi

# Assign the optional repeat number argument
repeat_number=$2

# Check which argument is provided and act accordingly
case $1 in
    "all")
        for app in "${all_apps[@]}"; do
            clean_app "$app" "$repeat_number"
        done
        ;;
    "gemm")
        for app in "${gemm_apps[@]}"; do
            clean_app "$app" "$repeat_number"
        done
        ;;
    "sci")
        for app in "${sci_apps[@]}"; do
            clean_app "$app" "$repeat_number"
        done
        ;;
    *)
        # If not a group, assume it's an individual directory
        clean_app "$1" "$repeat_number"
        ;;
esac
