#!/bin/bash

run_for_application() {
  local app_name=$1
  local mode=$2
  local repeat_idx=$3

  if [ -z "$mode" ]; then
    for m in 2 3; do
      if [ -z "$repeat_idx" ]; then
        for idx in {0..4}; do
          python3 feedback.py "$app_name" "$m" "$idx"
        done
      else
        python3 feedback.py "$app_name" "$m" "$repeat_idx"
      fi
    done
  else
    if [ -z "$repeat_idx" ]; then
      for idx in {0..4}; do
        python3 feedback.py "$app_name" "$mode" "$idx"
      done
    else
      python3 feedback.py "$app_name" "$mode" "$repeat_idx"
    fi
  fi
}

app_name=$1
mode=$2
repeat_idx=$3

if [ -z "$app_name" ]; then
  echo "Error: Please specify an app name."
  exit 1
fi

# Handle the case where app_name is "all", "sci", "gemm", or "feed"
case $app_name in
  "all")
    run_for_application "circuit" "$mode" "$repeat_idx"
    run_for_application "stencil" "$mode" "$repeat_idx"
    run_for_application "pennant" "$mode" "$repeat_idx"
    run_for_application "cannon" "$mode" "$repeat_idx"
    run_for_application "pumma" "$mode" "$repeat_idx"
    run_for_application "summa" "$mode" "$repeat_idx"
    run_for_application "solomonik" "$mode" "$repeat_idx"
    run_for_application "johnson" "$mode" "$repeat_idx"
    run_for_application "cosma" "$mode" "$repeat_idx"
    ;;
  "sci")
    run_for_application "circuit" "$mode" "$repeat_idx"
    run_for_application "stencil" "$mode" "$repeat_idx"
    run_for_application "pennant" "$mode" "$repeat_idx"
    ;;
  "gemm")
    run_for_application "cannon" "$mode" "$repeat_idx"
    run_for_application "pumma" "$mode" "$repeat_idx"
    run_for_application "summa" "$mode" "$repeat_idx"
    run_for_application "solomonik" "$mode" "$repeat_idx"
    run_for_application "johnson" "$mode" "$repeat_idx"
    run_for_application "cosma" "$mode" "$repeat_idx"
    ;;
  "feed")
    run_for_application "cannon" "$mode" "$repeat_idx"
    run_for_application "cosma" "$mode" "$repeat_idx"
    run_for_application "circuit" "$mode" "$repeat_idx"
    ;;
  *)
    run_for_application "$app_name" "$mode" "$repeat_idx"
    ;;
esac
