import os
import sys

import numpy as np
import pandas as pd

sys.path.append(os.path.realpath(os.path.join(os.path.dirname(__file__), os.path.pardir, os.path.pardir, 'src')))
sys.path.append(os.path.realpath(os.path.join(os.path.dirname(__file__), os.path.pardir)))
from data.preprocessing import save_statistics
from utils.metadata import DATA_DIRECTORY
from experiment_utils import make_experiment


if __name__ == '__main__':
    experiment = make_experiment()


    @experiment.config
    def config():
        data_dir = os.path.join(DATA_DIRECTORY, 'WADI', 'WADI_A2_19_Nov_2019')


    @experiment.automain
    def main(data_dir, _run):
        file = os.path.join(data_dir, 'WADI_14days_new.csv')

        print(f'Reading file "{file}"!')
        data = pd.read_csv(file)
        data = data.drop(columns=['Row', 'Date', 'Time', '2_LS_001_AL', '2_LS_002_AL', '2_P_001_STATUS',
                                  '2_P_002_STATUS'])
        nan_rows, = np.nonzero(data.isna().any(axis=1).to_numpy())
        for i in nan_rows:
            row = data.iloc[i]
            nonzero, = np.nonzero(row.isna().to_numpy())
            data.iloc[i, nonzero] = data.iloc[i - 1, nonzero]

        file_info = list(os.path.splitext(os.path.basename(file)))

        # Save dataset statistics
        stats_file = os.path.join(data_dir, f'{file_info[0]}_stats.npz')
        save_statistics(data, stats_file)
