import os
import sys

import pandas as pd

sys.path.append(os.path.realpath(os.path.join(os.path.dirname(__file__), os.path.pardir, os.path.pardir, 'src')))
sys.path.append(os.path.realpath(os.path.join(os.path.dirname(__file__), os.path.pardir)))
from data.preprocessing import save_statistics
from experiment_utils import make_experiment
from utils.metadata import DATA_DIRECTORY
from data.smd_dataset import SMDDataset, FILENAMES


if __name__ == '__main__':
    experiment = make_experiment()


    @experiment.config
    def config():
        data_dir = os.path.join(DATA_DIRECTORY, 'smd')


    @experiment.automain
    def main(data_dir, _run):

        for server_id in range(28):

            train_data = SMDDataset(server_id, training=True, standardize=False)

            data = pd.DataFrame(train_data[0][0][0].numpy())

            file_info = FILENAMES[server_id].split('.')

            # Save dataset statistics
            stats_file = os.path.join(data_dir, f'{file_info[0]}_stats.npz')
            save_statistics(data, stats_file)
