This directory contains all functions relevant for data loading and processing.

<details>
<summary> dataset</summary>

<details>
<summary> class DatasetMixin(abc.ABC) </summary>
     
     |  Method resolution order:
     |      DatasetMixin
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __len__(self) -> int
     |      This should return the number of independent time series in the dataset
     |  
     |  ----------------------------------------------------------------------
     |  Static methods defined here:
     |  
     |  get_default_pipeline() -> Dict[str, Dict[str, Any]]
     |      Return the default pipeline for this dataset that is used if the user does not specify a different pipeline.
     |      This must be a dict of the form
     |      {
     |          '<name>': {'class': '<name-of-transform-class>', 'args': {'<args-for-constructor>', ...}},
     |          ...
     |      }
     |      :return:
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties defined here:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors defined here:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset({'__len__', 'get_default_pipeline', 'n...
</details>
</details>

<details>
<summary>transforms</summary>

<details>
<summary>CLASSES</summary>

    abc.ABC(builtins.object)
        Transform
            CacheTransform
            DatasetSource
            InjectArtificialAnomaliesTransform
                InjectIndependentArtificialAnomaliesTransform
                InjectWindowsArtificialAnomaliesTransform
            LimitTransform
            OneVsRestTargetTransform
            OverlapPredictionTargetTransform
            ReconstructionTargetTransform
            SubsampleTransform
            WindowTransform
                PredictionTargetTransform
    data.dataset.DatasetMixin(abc.ABC)
        PipelineDataset(torch.utils.data.dataset.Dataset, data.dataset.DatasetMixin)
    torch.utils.data.dataset.Dataset(typing.Generic)
        PipelineDataset(torch.utils.data.dataset.Dataset, data.dataset.DatasetMixin)

<details>
<summary>class CacheTransform(Transform)</summary>

     |  CacheTransform(parent: src.data.transforms.Transform)
     |  
     |  Method resolution order:
     |      CacheTransform
     |      Transform
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __init__(self, parent: src.data.transforms.Transform)
     |      Caches the results from a previous transform in memory so that expensive calculations do not have to be
     |      recomputed.
     |      
     |      :param parent: Another transform which is used as the data source for this transform.
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset()
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from Transform:
     |  
     |  __len__(self) -> Optional[int]
     |      This should return the number of available sequences after the transformation.
     |  
     |  get_datapoint(self, item: int) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |      Returns a datapoint (in our case this is a sequence) from this transform.
     |      
     |      :param item: Must be 0<=item<len(self)
     |      :return: A datapoint of the form (inputs, targets), where inputs and targets are tuples of tensors.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties inherited from Transform:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors inherited from Transform:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
</details>
<details>
<summary>class DatasetSource(Transform)</summary>

     |  DatasetSource(dataset: torch.utils.data.dataset.Dataset, start: Union[int, List[int]] = 0, end: Union[int, List[int]] = 0, axis: str = 'batch')
     |  
     |  Method resolution order:
     |      DatasetSource
     |      Transform
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __init__(self, dataset: torch.utils.data.dataset.Dataset, start: Union[int, List[int]] = 0, end: Union[int, List[int]] = 0, axis: str = 'batch')
     |      This acts as a source transform (meaning it has no parent) that simply returns sequences from a given dataset.
     |      It can be constrained to return only a specific part of the data.
     |      
     |      :param dataset: The datset from which to take points.
     |      :param start: Start index for this dataset. Please see below for a more detailed explanation.
     |      :param end: End index for this dataset. Please see below for a more detailed explanation.
     |      :param axis: Can be either 'batch' or 'time'. In 'batch' mode, this simply returns only the sequences indexed from start to end. 'time' mode is used for datasets that contain only one long time series. That time series will be cut according to start and end.
     |  
     |  __len__(self)
     |      This should return the number of available sequences after the transformation.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties defined here:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset()
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from Transform:
     |  
     |  get_datapoint(self, item: int) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |      Returns a datapoint (in our case this is a sequence) from this transform.
     |      
     |      :param item: Must be 0<=item<len(self)
     |      :return: A datapoint of the form (inputs, targets), where inputs and targets are tuples of tensors.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors inherited from Transform:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
</details>
<details>
<summary>class InjectArtificialAnomaliesTransform(Transform)</summary>

     |  InjectArtificialAnomaliesTransform(parent: src.data.transforms.Transform, n: int, min_length: int = 1, max_length: int = 1)
     |  
     |  Method resolution order:
     |      InjectArtificialAnomaliesTransform
     |      Transform
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __init__(self, parent: src.data.transforms.Transform, n: int, min_length: int = 1, max_length: int = 1)
     |      This Transform injects anomalies into the dataset.
     |      
     |      It expects the get_datapoint method of its parent to return a tuple of tuples of length 1.
     |      
     |      :param parent: Another transform which is used as the data source for this transform.
     |      :type parent: Transform
     |      :param n: Number of anomalies to insert.
     |      :type n: int
     |      :param min_length: Minimum length of anomalies.
     |      :type min_length: int
     |      :param max_length: Maximum length of anomalies.
     |      :type max_length: int
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset({'_inject_anomaly'})
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from Transform:
     |  
     |  __len__(self) -> Optional[int]
     |      This should return the number of available sequences after the transformation.
     |  
     |  get_datapoint(self, item: int) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |      Returns a datapoint (in our case this is a sequence) from this transform.
     |      
     |      :param item: Must be 0<=item<len(self)
     |      :return: A datapoint of the form (inputs, targets), where inputs and targets are tuples of tensors.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties inherited from Transform:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors inherited from Transform:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
</details>
<details>
<summary>class InjectIndependentArtificialAnomaliesTransform(InjectArtificialAnomaliesTransform)</summary>

     |  InjectIndependentArtificialAnomaliesTransform(parent: src.data.transforms.Transform, anomaly_fn: Callable, n: int, min_length: int = 1, max_length: int = 1)
     |  
     |  Method resolution order:
     |      InjectIndependentArtificialAnomaliesTransform
     |      InjectArtificialAnomaliesTransform
     |      Transform
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __init__(self, parent: src.data.transforms.Transform, anomaly_fn: Callable, n: int, min_length: int = 1, max_length: int = 1)
     |      Transform that injects anomalies, that only depend on the anomaly interval.
     |      
     |      :param parent: Another transform which is used as the data source for this transform.
     |      :type parent: Transform
     |      :param anomaly_fn: Callable that adds an anomaly to an interval and returns a torch.Tensor of the same size as its input.
     |      :type anomaly_fn: Callable
     |      :param n: Number of anomalies to insert.
     |      :type n: int
     |      :param min_length: Minimum length of anomalies.
     |      :type min_length: int
     |      :param max_length: Maximum length of anomalies.
     |      :type max_length: int
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset()
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from Transform:
     |  
     |  __len__(self) -> Optional[int]
     |      This should return the number of available sequences after the transformation.
     |  
     |  get_datapoint(self, item: int) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |      Returns a datapoint (in our case this is a sequence) from this transform.
     |      
     |      :param item: Must be 0<=item<len(self)
     |      :return: A datapoint of the form (inputs, targets), where inputs and targets are tuples of tensors.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties inherited from Transform:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors inherited from Transform:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
</details>
<details>
<summary>class InjectWindowsArtificialAnomaliesTransform(InjectArtificialAnomaliesTransform)</summary>

     |  InjectWindowsArtificialAnomaliesTransform(parent: src.data.transforms.Transform, mask_fn: Callable, n: int, min_length: int = 1, max_length: int = 1)
     |  
     |  Method resolution order:
     |      InjectWindowsArtificialAnomaliesTransform
     |      InjectArtificialAnomaliesTransform
     |      Transform
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __init__(self, parent: src.data.transforms.Transform, mask_fn: Callable, n: int, min_length: int = 1, max_length: int = 1)
     |      Transform that inject windows from somewhere else in the dataset as anomalies.
     |      
     |      :param parent: Another transform which is used as the data source for this transform.
     |      :type parent: Transform
     |      :param mask_fn: Callable that computes a mask to the features of an interval.
     |      :type mask_fn: Callable
     |      :param n: Number of anomalies to insert.
     |      :type n: int
     |      :param min_length: Minimum length of anomalies.
     |      :type min_length: int
     |      :param max_length: Maximum length of anomalies.
     |      :type max_length: int
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset()
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from Transform:
     |  
     |  __len__(self) -> Optional[int]
     |      This should return the number of available sequences after the transformation.
     |  
     |  get_datapoint(self, item: int) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |      Returns a datapoint (in our case this is a sequence) from this transform.
     |      
     |      :param item: Must be 0<=item<len(self)
     |      :return: A datapoint of the form (inputs, targets), where inputs and targets are tuples of tensors.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties inherited from Transform:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors inherited from Transform:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
</details>
<details>
<summary>class LimitTransform(Transform)</summary>

     |  LimitTransform(parent: src.data.transforms.Transform, count: int)
     |  
     |  Method resolution order:
     |      LimitTransform
     |      Transform
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __init__(self, parent: src.data.transforms.Transform, count: int)
     |      Limits the amount of data points returned.
     |      
     |      :param parent: Another transform which is used as the data source for this transform.
     |      :param count: The max number of sequences that should be returned by this transform.
     |  
     |  __len__(self)
     |      This should return the number of available sequences after the transformation.
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset()
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from Transform:
     |  
     |  get_datapoint(self, item: int) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |      Returns a datapoint (in our case this is a sequence) from this transform.
     |      
     |      :param item: Must be 0<=item<len(self)
     |      :return: A datapoint of the form (inputs, targets), where inputs and targets are tuples of tensors.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties inherited from Transform:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors inherited from Transform:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
</details>
<details>
<summary>class OneVsRestTargetTransform(Transform)</summary>

     |  OneVsRestTargetTransform(parent: src.data.transforms.Transform, normal_class: Optional[Any] = None, anomalous_class: Optional[Any] = None, replace_labels: bool = False)
     |  
     |  Method resolution order:
     |      OneVsRestTargetTransform
     |      Transform
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __init__(self, parent: src.data.transforms.Transform, normal_class: Optional[Any] = None, anomalous_class: Optional[Any] = None, replace_labels: bool = False)
     |      Transforms multi-class labels into binary labels for anomaly detection. "Normal" data points will have label 0,
     |      others will have label 1.
     |      
     |      :param parent: Another transform which is used as the data source for this transform.
     |      :param normal_class: The input class label that should be considered normal and will have label 0 in the output..
     |      :param anomalous_class: You can also specify an anomalous class that will have label 1. All other labels will be transformed to 0. Note that you cannot specify both normal_class and anomalous_class.
     |      :param replace_labels: Whether the original labels should be replaced by the transform. If False, the additional labels will be added to the tuple of original labels.
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset()
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from Transform:
     |  
     |  __len__(self) -> Optional[int]
     |      This should return the number of available sequences after the transformation.
     |  
     |  get_datapoint(self, item: int) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |      Returns a datapoint (in our case this is a sequence) from this transform.
     |      
     |      :param item: Must be 0<=item<len(self)
     |      :return: A datapoint of the form (inputs, targets), where inputs and targets are tuples of tensors.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties inherited from Transform:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors inherited from Transform:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
</details>
<details>
<summary>class OverlapPredictionTargetTransform(Transform)</summary>

     |  OverlapPredictionTargetTransform(parent: src.data.transforms.Transform, offset: int, replace_labels: bool = False)
     |  
     |  Method resolution order:
     |      OverlapPredictionTargetTransform
     |      Transform
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __init__(self, parent: src.data.transforms.Transform, offset: int, replace_labels: bool = False)
     |      Adds the sequence shifted by offset as the target.
     |      
     |      :param parent: Another transform which is used as the data source for this transform.
     |      :param offset: Number of steps ahead that should be predicted.
     |      :param replace_labels: Whether the original labels should be replaced by the reconstruction target. If False, the reconstruction target will be added to the tuple of original labels.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties defined here:
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset()
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from Transform:
     |  
     |  __len__(self) -> Optional[int]
     |      This should return the number of available sequences after the transformation.
     |  
     |  get_datapoint(self, item: int) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |      Returns a datapoint (in our case this is a sequence) from this transform.
     |      
     |      :param item: Must be 0<=item<len(self)
     |      :return: A datapoint of the form (inputs, targets), where inputs and targets are tuples of tensors.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties inherited from Transform:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors inherited from Transform:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
</details>
<details>
<summary>class PipelineDataset(torch.utils.data.dataset.Dataset, data.dataset.DatasetMixin)</summary>

     |  PipelineDataset(sink_transform: src.data.transforms.Transform)
     |  
     |  Method resolution order:
     |      PipelineDataset
     |      torch.utils.data.dataset.Dataset
     |      typing.Generic
     |      data.dataset.DatasetMixin
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __getitem__(self, item) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |  
     |  __init__(self, sink_transform: src.data.transforms.Transform)
     |      Dataset that can be used with a `torch.utils.data.Dataloader` and executes a pipeline of transforms to retrieve
     |      its datapoints.
     |      
     |      :param sink_transform: The last transform in the pipeline that should be queried for data points.
     |  
     |  __iter__(self)
     |  
     |  __len__(self)
     |      This should return the number of independent time series in the dataset
     |  
     |  save(self, path: str, chunk_size: int = 0, batch_dim: int = 0)
     |      Save this dataset as it would be returned after all processing by transforms is done.
     |      
     |      :param path: The folder in which to save the dataset.
     |      :param chunk_size: The maximum number of data points that should be saved in one file. If there are more data points than this value, multiple files will be created. Set this to 0 to save the entire dataset in one file.
     |      :param batch_dim: All (or `chunk_size`) datapoints will be stacked along this axis in a new tensor that is the saved to disk.
     |  
     |  ----------------------------------------------------------------------
     |  Static methods defined here:
     |  
     |  get_default_pipeline() -> Dict[str, Dict[str, Any]]
     |      Return the default pipeline for this dataset that is used if the user does not specify a different pipeline.
     |      This must be a dict of the form
     |      {
     |          '<name>': {'class': '<name-of-transform-class>', 'args': {'<args-for-constructor>', ...}},
     |          ...
     |      }
     |      :return:
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties defined here:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset()
     |  
     |  __parameters__ = ()
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from torch.utils.data.dataset.Dataset:
     |  
     |  __add__(self, other: 'Dataset[T_co]') -> 'ConcatDataset[T_co]'
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors inherited from torch.utils.data.dataset.Dataset:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes inherited from torch.utils.data.dataset.Dataset:
     |  
     |  __orig_bases__ = (typing.Generic[+T_co],)
     |  
     |  ----------------------------------------------------------------------
     |  Class methods inherited from typing.Generic:
     |  
     |  __class_getitem__(params) from abc.ABCMeta
     |  
     |  __init_subclass__(*args, **kwargs) from abc.ABCMeta
     |      This method is called when a class is subclassed.
     |      
     |      The default implementation does nothing. It may be
     |      overridden to extend subclasses.
</details>
<details>
<summary>class PredictionTargetTransform(WindowTransform)</summary>

     |  PredictionTargetTransform(parent: src.data.transforms.Transform, window_size: int, prediction_horizon: int, replace_labels: bool = False, step_size: int = 1, reverse: bool = False)
     |  
     |  Method resolution order:
     |      PredictionTargetTransform
     |      WindowTransform
     |      Transform
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __init__(self, parent: src.data.transforms.Transform, window_size: int, prediction_horizon: int, replace_labels: bool = False, step_size: int = 1, reverse: bool = False)
     |      Adds the last prediction_window points from the current inputs as targets for prediction objectives.
     |      
     |      :param parent: Another transform which is used as the data source for this transform.
     |      :param prediction_horizon: Number of datapoints that should be predicted.
     |      :param replace_labels: Whether the original labels should be replaced by the reconstruction target. If False, the reconstruction target will be added to the tuple of original labels.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties defined here:
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset()
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from WindowTransform:
     |  
     |  __len__(self)
     |      This should return the number of available sequences after the transformation.
     |  
     |  inverse_transform_index(self, item) -> Tuple[int, int]
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from Transform:
     |  
     |  get_datapoint(self, item: int) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |      Returns a datapoint (in our case this is a sequence) from this transform.
     |      
     |      :param item: Must be 0<=item<len(self)
     |      :return: A datapoint of the form (inputs, targets), where inputs and targets are tuples of tensors.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties inherited from Transform:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors inherited from Transform:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
</details>
<details>
<summary>class ReconstructionTargetTransform(Transform)</summary>

     |  ReconstructionTargetTransform(parent: src.data.transforms.Transform, replace_labels: bool = False)
     |  
     |  Method resolution order:
     |      ReconstructionTargetTransform
     |      Transform
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __init__(self, parent: src.data.transforms.Transform, replace_labels: bool = False)
     |      Adds the current inputs as targets for reconstruction objectives.
     |      
     |      :param parent: Another transform which is used as the data source for this transform.
     |      :param replace_labels: Whether the original labels should be replaced by the reconstruction target. If False, the reconstruction target will be added to the tuple of original labels.
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset()
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from Transform:
     |  
     |  __len__(self) -> Optional[int]
     |      This should return the number of available sequences after the transformation.
     |  
     |  get_datapoint(self, item: int) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |      Returns a datapoint (in our case this is a sequence) from this transform.
     |      
     |      :param item: Must be 0<=item<len(self)
     |      :return: A datapoint of the form (inputs, targets), where inputs and targets are tuples of tensors.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties inherited from Transform:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors inherited from Transform:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
</details>
<details>
<summary>class SubsampleTransform(Transform)</summary>

     |  SubsampleTransform(parent: src.data.transforms.Transform, subsampling_factor: int, aggregation: str = 'first')
     |  
     |  Method resolution order:
     |      SubsampleTransform
     |      Transform
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __init__(self, parent: src.data.transforms.Transform, subsampling_factor: int, aggregation: str = 'first')
     |      Subsample sequences by a specified factor. `subsampling_factor` consecutive datapoints in a sequence will be
     |      aggregated into one point using the `aggregation` function.
     |      
     |      :param parent: Another transform which is used as the data source for this transform.
     |      :param subsampling_factor: This specifies the number of consecutive data points that will be aggregated.
     |      :param aggregation: The function that should be applied to aggregate a window of data points. Can be either 'mean', 'last' or 'first'.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties defined here:
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset()
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from Transform:
     |  
     |  __len__(self) -> Optional[int]
     |      This should return the number of available sequences after the transformation.
     |  
     |  get_datapoint(self, item: int) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |      Returns a datapoint (in our case this is a sequence) from this transform.
     |      
     |      :param item: Must be 0<=item<len(self)
     |      :return: A datapoint of the form (inputs, targets), where inputs and targets are tuples of tensors.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties inherited from Transform:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors inherited from Transform:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
</details>
<details>
<summary>class Transform(abc.ABC)</summary>

     |  Transform(parent: Optional[ForwardRef('Transform')])
     |  
     |  Base class for all transforms. A Transform processes one (or several) data points and outputs them. Transforms can
     |  be chained in a pull-based pipeline.
     |  
     |  Method resolution order:
     |      Transform
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __init__(self, parent: Optional[ForwardRef('Transform')])
     |      Initialize a transform.
     |      
     |      :param parent: Another transform which is used as the data source for this transform. CVan be none in the case
     |      of a source.
     |  
     |  __len__(self) -> Optional[int]
     |      This should return the number of available sequences after the transformation.
     |  
     |  get_datapoint(self, item: int) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |      Returns a datapoint (in our case this is a sequence) from this transform.
     |      
     |      :param item: Must be 0<=item<len(self)
     |      :return: A datapoint of the form (inputs, targets), where inputs and targets are tuples of tensors.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties defined here:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors defined here:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset({'_get_datapoint_impl'})
</details>
<details>
<summary>class WindowTransform(Transform)</summary>

     |  WindowTransform(parent: src.data.transforms.Transform, window_size: int, step_size: int = 1, reverse: bool = False)
     |  
     |  Method resolution order:
     |      WindowTransform
     |      Transform
     |      abc.ABC
     |      builtins.object
     |  
     |  Methods defined here:
     |  
     |  __init__(self, parent: src.data.transforms.Transform, window_size: int, step_size: int = 1, reverse: bool = False)
     |      This transform produces sliding windows from input sequences. Incomplete windows (that can appear if
     |      `step_size>1`) will not be returned.
     |      
     |      :param parent: Another transform which is used as the data source for this transform.
     |      :param window_size: The size of each window.
     |      :param step_size: The step size at which the sliding window is moved along the sequence.
     |      :param reverse: If this is True, start the sliding window at the end of a sequence, instead of the start. Note that this will not reverse the order of sequences in the dataset and only applies within a single sequence.
     |  
     |  __len__(self)
     |      This should return the number of available sequences after the transformation.
     |  
     |  inverse_transform_index(self, item) -> Tuple[int, int]
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties defined here:
     |  
     |  seq_len
     |      This should return the length of each time series. If the time series have different lengths, the return
     |      value should be a list that contains the length of each sequence. If all sequences are of equal length,
     |      this should return an int.
     |  
     |  ----------------------------------------------------------------------
     |  Data and other attributes defined here:
     |  
     |  __abstractmethods__ = frozenset()
     |  
     |  ----------------------------------------------------------------------
     |  Methods inherited from Transform:
     |  
     |  get_datapoint(self, item: int) -> Tuple[Tuple[torch.Tensor, ...], Tuple[torch.Tensor, ...]]
     |      Returns a datapoint (in our case this is a sequence) from this transform.
     |      
     |      :param item: Must be 0<=item<len(self)
     |      :return: A datapoint of the form (inputs, targets), where inputs and targets are tuples of tensors.
     |  
     |  ----------------------------------------------------------------------
     |  Readonly properties inherited from Transform:
     |  
     |  num_features
     |      Number of features of each datapoint. This can also be a tuple if the data has more than one feature dimension.
     |  
     |  ----------------------------------------------------------------------
     |  Data descriptors inherited from Transform:
     |  
     |  __dict__
     |      dictionary for instance variables (if defined)
     |  
     |  __weakref__
     |      list of weak references to the object (if defined)
</details>
</details>
<details>
<summary>FUNCTIONS</summary>

<details>
<summary>full_mask(inputs: torch.Tensor) -> torch.Tensor</summary>

</details>
<details>
<summary>make_dataset_split(dataset: torch.utils.data.dataset.Dataset, *splits: float, axis: str = 'batch')</summary>

    Create `DatasetSource`s for different parts of a given dataset.

    :param dataset: The dataset, for which the split should be done.
    :param splits: This should be the percentages of the dataset in each split. Will be normalized to 100%.
    :param axis: The axis along which to split the dataset. Please see `DatasetSource` for a more detailed explanation.
    :return: This will return a generator that yields `DatasetSources` according to the specified splits.
</details>
</details>
</details>
