#!/bin/bash

# nohup ./bash_scripts/run_rsna.sh &

experiment_name=run_rsna

mkdir -p output/${experiment_name}

rm output/${experiment_name}/out_*

export CUDA_DEVICE_ORDER=PCI_BUS_ID

export CUDA_VISIBLE_DEVICES=1

seeds_array=(1 2 3 4 5)

num_workers=12
val_prop=0.2

epochs=50
patience=$epochs

dataset=rsna-features_resnet18

batch_size=32

############################################################################################################

model_name=abmil

lr_array=(0.0001 0.00001)

# ABMIL

alpha_array=(0.0)
for seed in "${seeds_array[@]}"
do
    for lr in "${lr_array[@]}"
    do
        python code/experiments/run_experiment.py --mode=train_test --use_wandb --num_workers=$num_workers --seed=$seed \
            --dataset=$dataset --batch_size=$batch_size --epochs=$epochs --val_prop=$val_prop \
            --model_name=$model_name --lr=$lr --patience=$patience --balance_loss \
            --alpha=0.0 > output/${experiment_name}/out_${BASHPID}.txt 2>&1
    done
done

# SmAP

alpha_array=(trainable)
smooth_mode_array=(approx_10)
smooth_where_array=(att_representation representation att_values)
for seed in "${seeds_array[@]}"
do
    for lr in "${lr_array[@]}"
    do
        for smooth_mode in "${smooth_mode_array[@]}"
        do
            for smooth_where in "${smooth_where_array[@]}"
            do
                for alpha in "${alpha_array[@]}"
                do
                    python code/experiments/run_experiment.py --mode=train_test --use_wandb --num_workers=$num_workers --seed=$seed \
                        --dataset=$dataset --batch_size=$batch_size --epochs=$epochs --val_prop=$val_prop \
                        --model_name=$model_name --lr=$lr --patience=$patience --balance_loss --use_inst_distances \
                        --alpha=$alpha --smooth_mode=$smooth_mode  --smooth_where=$smooth_where --spectral_norm > output/${experiment_name}/out_${BASHPID}.txt 2>&1
                done
            done
        done
    done
done


############################################################################################################

# SmTAP

model_name=transformer_abmil

transf_num_layers_array=(2)
transf_att_dim=128
transf_num_heads=8

lr_array=(0.0001 0.00001)


transf_smooth_steps_array=(0 10)
smooth_where_array=(none representation att_representation att_values)
for seed in "${seeds_array[@]}"
do
    for lr in "${lr_array[@]}"
    do
        for transf_num_layers in "${transf_num_layers_array[@]}"
        do
            for transf_smooth_steps in "${transf_smooth_steps_array[@]}"
            do
                for smooth_where in "${smooth_where_array[@]}"
                do
                    python code/experiments/run_experiment.py --mode=train_test --use_wandb --num_workers=$num_workers --seed=$seed \
                        --dataset=$dataset --batch_size=$batch_size --epochs=$epochs --val_prop=$val_prop \
                        --model_name=$model_name --lr=$lr --patience=$patience --balance_loss --use_inst_distances \
                        --transf_num_layers=$transf_num_layers --transf_att_dim=$transf_att_dim  --transf_num_heads=$transf_num_heads --transf_smooth_steps=$transf_smooth_steps \
                        --alpha=trainable --smooth_mode=approx_10 --smooth_where=$smooth_where --spectral_norm > output/${experiment_name}/out_${BASHPID}.txt 2>&1
                done
            done
        done
    done
done

############################################################################################################

# CAMIL

batch_size=32
lr_array=(0.0001 0.00001)
model_name=camil

for seed in "${seeds_array[@]}"
do
    for lr in "${lr_array[@]}"
    do
        python code/experiments/run_experiment.py --mode=train_test --use_wandb --num_workers=$num_workers --seed=$seed \
            --dataset=$dataset --batch_size=$batch_size --epochs=$epochs --patience=$patience --balance_loss --val_prop=$val_prop \
            --model_name=$model_name --lr=$lr > output/${experiment_name}/out_${BASHPID}.txt 2>&1
    done
done