# Image Restoration based Generative Model

## Train MNIST
python3 train_DSWD.py --exp dgm --dataset mnist --image_size 32 --num_channels 1 --num_timesteps 4 --fir --resblock_type ddpm --lr_d 1e-4 --lmbda 0.001 --forward_name ddpm --resamp_with_conv --r1_gamma 0.02 --lazy_reg 15

## Train Cifar10
python3 train.py --exp dgm --lmbda 0.001 --lr_d 1e-4 --forward_name ddpm --num_timesteps 4

python3 train.py --exp sr --lmbda 0.001 --lr_d 1e-4 --forward_name sr --num_timesteps 7 --num_epoch 1800

## Train CELEBA-256
python3 train.py --exp celeba --dataset celeba_256 --image_size 256  --save_ckpt_every 25 --fid_every 100 --lr_d 1e-4 --lr_g 2e-4 --num_channels_dae 64 --n_mlp 3 --ch_mult 1 1 2 2 4 4 --batch_size 32 --num_epoch 700 --r1_gamma 2. --lazy_reg 10 --forward_name ddpm --num_timesteps 4 --lmbda 0.00005

## Train LSUN 256x256
python3 train.py --exp lsun --dataset lsun --image_size 256 --save_ckpt_every 25 --fid_every 25 --lr_d 1e-4 --lr_g 2e-4 --num_channels_dae 64 --n_mlp 3 --ch_mult 1 1 2 2 4 4 --batch_size 64 --num_epoch 300 --ema_decay 0.999 --r1_gamma 1. --lazy_reg 10 --lmbda 0.00001 --forward_name ddpm

## Evaluate SR and Inpaint
sh restore.sh