import numpy as np
import argparse
import faiss
import warnings
import scanpy as sc
import time
import matplotlib.pyplot as plt
from sklearn import metrics
import seaborn as sns
import random
import numpy as np
import ot


def Normalization_A (data):
    mean = np.mean(data)
    std_dev = np.std(data)
    standardized_data = (data - mean) / std_dev
    return standardized_data


def compute_kernel_bias(vecs, n_components):
    vecs = np.concatenate(vecs, axis=0)
    mu = vecs.mean(axis=0, keepdims=True)
    cov = np.cov(vecs.T)
    u, s, vh = np.linalg.svd(cov)
    W = np.dot(u, np.diag(s**0.5))
    W = np.linalg.inv(W.T)
    W = W[:, :n_components]

    return W, -mu


def compute_total_kernel_bias(embeddings, sequencing, N_COMPONENTS):
    total = np.empty(shape=[0, embeddings.shape[1]])
    for i in range(len(sequencing)):
        total = np.append(total, embeddings[i].reshape(1, -1), axis=0)
    total_80_sample = random.sample(list(total), int(len(total) * 0.8))
    kernel_total, bias_total = compute_kernel_bias([total_80_sample], N_COMPONENTS)

    return kernel_total, bias_total


def Normalization_B (vecs, kernel, bias):
    if not (kernel is None or bias is None):
        vecs = (vecs + bias).dot(kernel)

    return vecs / (vecs**2).sum(axis=1, keepdims=True)**0.5


def Normalization_C(method1, method2, typesA, typesB):
    M = ot.dist(method1, method2)
    M /= M.max()
    P = ot.emd([], [], M)

    indices_ot_mapping = np.argmax(P, axis=1)
    ratio = 0.0

    for i in range(len(typesA)):
        if typesA[i] == typesB[indices_ot_mapping[i]]:
            ratio += 1
    ratio /= len(typesA)
    print("Ratio OT: ", ratio)

    return indices_ot_mapping

