using HDF5
using CellFishing

let splits = 1
while splits <= 9
  fid = h5open(string("data_method/reference_", splits, ".h5ad"))
  data=read(fid)
  counts = zeros(length(data["obs"]["_index"]),length(data["var"]["_index"]))

  let counter = 1
    for (index,i) in enumerate(data["X"]["indptr"][2:end]), j in data["X"]["indices"][data["X"]["indptr"][index]+1:i]
      counts[index,j+1] = data["X"]["data"][counter]
      counter = counter + 1
    end
  end
      
  featurenames = data["var"][ "ensembl_id"]
  #"disease"
  #"cell_type"
  #cellnames =[ data["obs"]["CellType"]["categories"][i+1] for i in data["obs"]["CellType"]["codes"]]
  cellnames =[ data["obs"]["Method"]["categories"][i+1] for i in data["obs"]["Method"]["codes"]]
  counts = Matrix{Int}(counts)

  features = CellFishing.selectfeatures(transpose(counts), featurenames)
  database = CellFishing.CellIndex(transpose(counts), features, metadata=cellnames)
  
  fid = h5open(string("data_method/query_", splits, ".h5ad"))
  data=read(fid)
  counts = zeros(length(data["obs"]["_index"]),length(data["var"]["_index"]))
  let counter = 1
    for (index,i) in enumerate(data["X"]["indptr"][2:end]), j in data["X"]["indices"][data["X"]["indptr"][index]+1:i]
      counts[index,j+1] = data["X"]["data"][counter]
      counter = counter + 1
    end
  end
      
  featurenames = data["var"][ "ensembl_id"]
  #"disease"
  #"cell_type"
  #cellnames =[ data["obs"]["CellType"]["categories"][i+1] for i in data["obs"]["CellType"]["codes"]]
  cellnames =[ data["obs"]["Method"]["categories"][i+1] for i in data["obs"]["Method"]["codes"]]
  counts = Matrix{Int}(counts)

  for k in [100]
    # Search the database for similar cells; k cells will be returned per query.
    neighbors = CellFishing.findneighbors(k, transpose(counts), featurenames, database)
    # Write the neighboring cells to a file.
    open(string("neighbors_Method_",splits,"_",k,"-Method.tsv"), "w") do file
        println(file, join(["cell"; string.("n", 1:k)], '\t'))
        for j in 1:length(cellnames)
            print(file, cellnames[j])
            for i in 1:k
                print(file, '\t', database.metadata[neighbors.indexes[i,j]])
            end
            println(file)
        end
    end
    
  end
  splits = splits+1
end
end