import scanpy as sc
import os
import argparse
import tempfile
import pickle
import numpy as np
from sklearn.decomposition import PCA

def parse_args():
    parse = argparse.ArgumentParser(description='Cell Embedding Retrieval from data')
    parse.add_argument('--input_adata', default=None, type=str, help='Input file path')
    parse.add_argument('--output_data', default=None, type=str, help='Output file directory')
    parse.add_argument('--query_index',default=None)
    parse.add_argument('--target_index',default=None)
    parse.add_argument('--output_dir',default=None)

    args = parse.parse_args()  
    return args

args = parse_args()
adata_path = args.input_adata
adata = sc.read(
    adata_path
)

if args.query_index is not None:
    query_indexes = np.load(args.query_index)
    train_index = np.array([i for i in range(len(adata)) if i not in query_indexes])
    training_adata = adata[train_index]
elif args.target_index is not None:
    target_indexs = np.loadtxt(args.target_index,dtype=int)
    training_adata = adata[target_indexs]
else:
    training_adata = adata
    print("no cell filtered")

pca = PCA(n_components=30,svd_solver="arpack")
pca.fit(training_adata.X)
npy_output=pca.transform(adata.X)
os.makedirs(args.output_dir,exist_ok=True)
np.save(args.output_data ,npy_output)
