import sys
from pathlib import Path
import numpy as np
import pandas as pd
import scanpy as sc
import argparse
import os
sys.path.insert(0, "../")
import scgpt as scg

parser = argparse.ArgumentParser(description='Process single-cell data.')
parser.add_argument('--input_adata', type=str, required=True, help='Path to input .h5ad file')
parser.add_argument('--output_adata', type=str, required=True, help='Path to output .npy file')
parser.add_argument('--model_path', type=str, required=True, help='Path to scgpt model')
args = parser.parse_args()

model_dir=Path(args.model_path)
adata=sc.read_h5ad(args.input_adata)
cell_type_key = "Celltype"
gene_col = "index"

ref_embed_adata = scg.tasks.embed_data(
    adata,
    model_dir,
    gene_col=gene_col,
    obs_to_save=cell_type_key,
    batch_size=64,
    return_new_adata=True,
)

ref_embed_adata.write(args.output_path)
