import os
os.environ["CUDA_VISIBLE_DEVICES"] = "0"
import scanpy as sc
import numpy as np
import scMulan
from scMulan import GeneSymbolUniform
import argparse
import time

parser = argparse.ArgumentParser(description='Process single-cell data.')
parser.add_argument('--input_adata', type=str, required=True, help='Path to input .h5ad file')
parser.add_argument('--output_adata', type=str, required=True, help='Path to output .npy file')
args = parser.parse_args()
paths = [args.input_adata]

for data_path in paths:
    parts = data_path.split('/')
    name = parts[-1].split('.')[0]
    adata = sc.read(data_path)
    adata = adata[:10000]
    adata.var_names = adata.var.gene_name
    adata_GS_uniformed = GeneSymbolUniform(input_adata=adata,
                                           output_dir="Data/",
                                           output_prefix=name)

    sc.pp.normalize_total(adata_GS_uniformed, target_sum=1e4)
    sc.pp.log1p(adata_GS_uniformed)

    ckp_path = 'ckpt/ckpt_scMulan.pt'
    scml = scMulan.model_inference(ckp_path, adata_GS_uniformed)
    base_process = scml.cuda_count()
    start_cpu_time = time.process_time()
    scml.get_cell_types_and_embds_for_adata(parallel=False)

    execution_time = time.process_time() - start_cpu_time
    print(f"Embedding extraction time in seconds: {execution_time:.6f} seconds")
    adata_embds = scml.adata.obsm['X_scMulan'].copy()
    adata_embds.obs = scml.adata.obs
    np.save(f"{args.output_adata}"
            f"{data_path.split('z/')[-1].split('.')[0]}.npy", adata_embds)
