## Hadamax-PQN Usage  (Docker is recommended!)

Steps:

1. Ensure you have Docker and the [NVIDIA Container Toolkit](https://docs.nvidia.com/datacenter/cloud-native/container-toolkit/latest/install-guide.html) properly installed.
2. (Optional) Set your WANDB key in the [Dockerfile](docker/Dockerfile).
3. Build with `bash docker/build_atari.sh`.
4. Run a container: `bash docker/run_atari.sh`
5. Test: `python purejaxql/pqn_atari_hadamax.py --ENCODER='hadamax' --ENV_NAME='Seaquest-v5`.

## Hadamax-C51 Usage  (virtualenv is recommended!)

1. Create a virtual environment and activate it.
2. Install the required packages: `pip install -r requirements/requirements_cleanrl.txt`.
3. Test: `python cleanrl/c51_hadamax.py --encoder='hadamax' --env_id='NameThisGameNoFrameskip-v4'`.

#### Commands:

```bash
# Train PQN in Atari with the Hadamax Encoder (Hadamax-PQN)
python purejaxql/pqn_atari_hadamax.py --ENCODER='hadamax'
# Train PQN in Atari with the Baseline Encoder (PQN)
python purejaxql/pqn_atari_hadamax.py --ENCODER='baseline'
# Train PQN in Atari with the Impala ResNet-15 Encoder (PQN ResNet-15)
python purejaxql/pqn_atari_hadamax.py --ENCODER='impala'
# Train cleanRL's Categorical DQN (C51) algorithm with a Hadamax-encoder
python cleanrl/c51_hadamax.py --encoder='hadamax' --ENV_NAME='NameThisGame-v5'
```
