# Fair4Free: Generating High-fidelity Fair Synthetic Samples using Data Free Distillation

Code base for the paper.

## Setting up the Environment

*As we use the [FairX](https://github.com/fahim-sikder/FairX) [1] to train and evaluate this work's benchmark, we decided to use Fairx's python environment. The following procedure will install the python environment for the FairX.*

```terminal
conda create --name distillation python=3.10

conda activate distillation

git clone git@github.com:fahim-sikder/FairX.git

cd FairX

pip install .
```

## Training distillation

### For Tabular

Navigate to the home directory of the folder. And run the following for tabular dataset:

```terminal
python3 train-tabular-distillation.py --dataset_name Adult-sex
```

Datasets options are as follows:

1. 'Adult-sex' (sex as sensitive attribute)
2. 'Adult-race' (race as sensitive attribute)
3. 'Compas-sex' (sex as sensitive attribute)
4. 'Compas-race' (race as sensitive attribute)

### For Image

```terminal
python3 train-image-distillation.py --dataset_name cmnist --sensitive_attr rgb
```

Datasets options are as follows:

1. 'celeba-rgb' (CelebA)
2. 'cmnist' (Color MNIST)

Sensitive attributes are:

1. 'Smiling' (CelebA)
2.  'rgb' (Color MNIST)

**Put the CelebA dataset path in the ``train-image-distillation.py`` file before running it.**

**The empirical evaluation result and generated samples from the model will be automatically saved inside each run directory.**





## References:

[1] Sikder, Md Fahim, et al. "FairX: A comprehensive benchmarking tool for model analysis using fairness, utility, and explainability." _arXiv preprint arXiv:2406.14281_ (2024).