# A Semi-Supervised Clustering Approach For Graph Learning with Neural Networks

This repository contains the code for the paper "A Semi-Supervised Clustering Approach For Graph Learning with Neural Networks".

To reproduce the results of the paper:

1. Use `HPC/config.sh` to run `HPC/config.py` to configure experiments to be run and to download the necessary datasets.
2. Use `HPC/meta_run.py` to run `HPC/run.py` to run the experiments on a SLURM cluster.
3. Use `HPC/results.sh` to run `HPC/results.py` to compile results to LaTeX tables and generate visualizations.

The scripts `HPC/config.sh`, `HPC/meta_run.py` and `HPC/results.sh` are intended for use on a [SLURM](https://slurm.schedmd.com/documentation.html) cluster with [Apptainer](https://apptainer.org/) (formerly Singularity).
Using Apptainer, the scripts pull and run the experiments on the [PyTorch Geometric (PyG)](https://pytorch-geometric.readthedocs.io/en/stable/) NVIDIA NGC container version [24.09](https://docs.nvidia.com/deeplearning/frameworks/pyg-release-notes/rel-24-09.html#rel-24-09).

To run the experiments on a local machine, the scripts `HPC/config.py`, `HPC/run.py` and `HPC/results.py` can be modified to run the experiments locally.
Refer to the container documentation for the necessary dependencies.
