# python3.7
"""Model zoo."""

# pylint: disable=line-too-long

MODEL_ZOO = {
    # PGGAN official.
    'pggan_celebahq1024': dict(
        gan_type='pggan',
        resolution=1024,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EW_3jQ6E7xlKvCSHYrbmkQQBAB8tgIv5W5evdT6-GuXiWw?e=gRifVa&download=1',
    ),
    'pggan_bedroom256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EUZQWGz2GT5Bh_GJLalP63IBvCsXDTOxDFIC_ZBsmoEacA?e=VNXiDb&download=1',
    ),
    'pggan_livingroom256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/Efzh6qQv6QtCm0YN1lulH-YByqdE3AqlI-E6US_hXMuiig?e=ppdyB2&download=1',
    ),
    'pggan_diningroom256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EcLb3_hGUkdClompZo27xk0BNmotgbFqdIeu-ZOGJsBMRg?e=xjYpN3&download=1',
    ),
    'pggan_kitchen256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/ESCyg6hpNn1LlHVX_un1wLsBZAORUNkW9MO2kU1X5kafAQ?e=09TbGC&download=1',
    ),
    'pggan_church256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EQ8cKujs2TVGjCL_j6bsnk8BqD9REF2ME2lBnpbTPsqIvA?e=zH55fT&download=1',
    ),
    'pggan_tower256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EeyBJvgRVGJClKr1KKYDF_cBT1FDepRU1-GLqYNh8W9-fQ?e=nrpa5N&download=1',
    ),
    'pggan_bridge256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EZ2QScfPy19PiDERLJQ3gPMBP4WmvZHwhNFLzfaP2YD8hQ?e=bef1U9&download=1',
    ),
    'pggan_restaurant256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/ERvJ4pz8jgtMrcuJXUfcOQEBDugZ099_TetCQs-9-ILCVg?e=qYsVdQ&download=1',
    ),
    'pggan_classroom256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EUU9SCOPUxhMoUS4Ceo9kl0BQkVK7d69lA-JeOP-zOWvXw?e=YIB4no&download=1',
    ),
    'pggan_conferenceroom256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EX8AF0_6NoJAl5vKFewHWnsBk0r4PK4WsqsMrJyj84TrqQ?e=oNQIZS&download=1',
    ),
    'pggan_person256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EWu4SqR42YpCoqsVJOcM2cMBcdfXA0j5wZ2hno9X0R9ydQ?e=KuDRns&download=1',
    ),
    'pggan_cat256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EQdveyUNOMtAue52n6BxoHoB6Yup5-PTvBDmyfUn7Un4Hw?e=7acGbT&download=1',
    ),
    'pggan_dog256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/ESaKyXA5fGlOvXJYDDFbT2kB9c0HlXh9n_wnyhiP05nhow?e=d4aKDV&download=1',
    ),
    'pggan_bird256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/Ef2p4Pd3AKVCmSm00YikCIABhylh2dLPaFjPfPVn3RiTXA?e=9bRitp&download=1',
    ),
    'pggan_horse256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EXwCPdv6XqJFtuvFFoswRScBmLJbhKzaC5D_iovl1GFOTw?e=WDdD77&download=1',
    ),
    'pggan_sheep256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/ER6J5EKjAUNFtm9VwLf-uUsBZ5dnqxeKsPxY9ijiPtMhcQ?e=OKtfva&download=1',
    ),
    'pggan_cow256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/ERZLxw7N7xJPm72FyePTbpcByzrr0pH-Fg7qyLt5tYGXwQ?e=ovIPCl&download=1',
    ),
    'pggan_car256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EfGc2we47aFDtAY1548pRvsByIju-uXRbkZEFpJotuPKZw?e=DQqVj8&download=1',
    ),
    'pggan_bicycle256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/Ed1dN_FgwmdBgeNWhaRUry8BgwT88-n2ppicSDPx-f7f_Q?e=bxTxnf&download=1',
    ),
    'pggan_motorbike256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EV3yQdeJXIdPjZbMO0mp2-MBJbKuuBdypzBL4gnedO57Dw?e=tXdvtD&download=1',
    ),
    'pggan_bus256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/Ed7-OYLnq0RCqRlM8qK8wZ8B87dz_NUxIKBrvyFUwRCEbg?e=VP5bmX&download=1',
    ),
    'pggan_train256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EedE2cozKOVAkhvbdLd4SfwBknFW8vWZnKiqgeIBbAvCCA?e=BrLpTl&download=1',
    ),
    'pggan_boat256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/Eb39waqQFr9Bp4wO0rC5NHwB0Vz2NGCuqbRPucguBIkDrg?e=lddSyL&download=1',
    ),
    'pggan_airplane256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/Ee6FzIx3KjNDhxrS5mDvpCEB3iQ7TgErmKhbwbV-eF07iw?e=xflPXa&download=1',
    ),
    'pggan_bottle256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EWhoy2AFCTZGtEG1UoayWjcB9Kdc_wreJ8p4RlBB93nbNg?e=DMZceU&download=1',
    ),
    'pggan_chair256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EbQRTfwdostBhXG30Uacn7ABsEUFa-tEW3oxiM5zDYQbRw?e=FkB7T0&download=1',
    ),
    'pggan_pottedplant256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EWg7hnoGATBOuJvXWr4m7CQBJL9o7nqnD6nOMRhtH2SKXg?e=Zi3hjD&download=1',
    ),
    'pggan_tvmonitor256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EVXwttoJVtBMuhHNDdK3cMwBdMiZARJV38PMTsL6whnFlA?e=RbG0ru&download=1',
    ),
    'pggan_diningtable256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EXVzBkbmTCVImMtuHLCTBeMBXZmv0RWyx5KXQQAe7-7D5w?e=6RYSnm&download=1',
    ),
    'pggan_sofa256': dict(
        gan_type='pggan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EaADQYDXwY9NrzbiUFcRYRgBOu1GdJMG8YgNZZmbNjbn-Q?e=DqKrXG&download=1',
    ),

    # StyleGAN official.
    'stylegan_ffhq1024': dict(
        gan_type='stylegan',
        resolution=1024,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EdfMxgb0hU9BoXwiR3dqYDEBowCSEF1IcsW3n4kwfoZ9OQ?e=VwIV58&download=1',
    ),
    'stylegan_celebahq1024': dict(
        gan_type='stylegan',
        resolution=1024,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EcCdXHddE7FOvyfmqeOyc9ABqVuWh8PQYFnV6JM1CXvFig?e=1nUYZ5&download=1',
    ),
    'stylegan_bedroom256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/Ea6RBPddjcRNoFMXm8AyEBcBUHdlRNtjtclNKFe89amjBw?e=Og8Vff&download=1',
    ),
    'stylegan_cat256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EVjX8u9HuehLip3z0hRfIHcB7QtoFkTB7NiRDb8nrKOl2w?e=lHcp1B&download=1',
    ),
    'stylegan_car512': dict(
        gan_type='stylegan',
        resolution=512,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EcRJNNzzUzJGjI2X53S9HjkBhXkKT5JRd6Q3IIhCY1AyRw?e=FvMRNj&download=1',
    ),

    # StyleGAN ours.
    'stylegan_celeba_partial256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/ET2etKNzMS9JmHj5j60fqMcBRJfQfYNvqUrujaIXxCvKDQ?e=QReLE6&download=1',
    ),
    'stylegan_ffhq256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/ES-NAUCC2qdHg87BftvlBiQBVpbJ8-005Q4TNr5KrOxQEw?e=00AnWt&download=1',
    ),
    'stylegan_ffhq512': dict(
        gan_type='stylegan',
        resolution=512,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EZYrrwOiEgVOg-PfGv7QTegBzFQ9yq2v7o1WxNq5JJ9KNA?e=SZU8PI&download=1',
    ),
    'stylegan_livingroom256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EfFCYLHjqbFDmjOvCCFJgDcBZ1QYgETfZJxp4ZTHjLxZBg?e=InVd0n&download=1',
    ),
    'stylegan_diningroom256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/ERsUza_hSFRIm4iZCag7P0kBQ9EIdfQKByw4QYt_ay97lg?e=Cimh7S&download=1',
    ),
    'stylegan_kitchen256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/ERcYvoingQNKix35lUs0vUkBQQkAZMp1rtDxjwNlOJAoaA?e=a1Tcwr&download=1',
    ),
    'stylegan_apartment256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EfurPNSB2BRFtXdqGkmDD6YBwyKN8YK2v7nKwnJQdsbf6A?e=w3oYa4&download=1',
    ),
    'stylegan_church256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/ETMgG1_d06tAlbUkJD1qA9IBaLZ9zJKPkG2kO-4jxhVV5w?e=Dbkb7o&download=1',
    ),
    'stylegan_tower256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/Ebm9QMgqB2VDqyIE5rFhreEBgZ_RyKcRf8bQ333K453u3w?e=if8sDj&download=1',
    ),
    'stylegan_bridge256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/Ed9QM6OP9sVHnazSp4cqPSEBb-ALfBPXRxP1hD7FsTYh8w?e=3vv06p&download=1',
    ),
    'stylegan_restaurant256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/ESDhYr01WtlEvBNFrVpFezcB2l9lF1rBYuHFoeNpBr5B7A?e=uFWFNh&download=1',
    ),
    'stylegan_classroom256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EbWnI3oto9NPk-lxwZlWqPQB2atWpGiTWMIT59MzF9ij9Q?e=KvcNBg&download=1',
    ),
    'stylegan_conferenceroom256': dict(
        gan_type='stylegan',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/Eb1gVi3pGa9PgJ4XYYu_6yABQZ0ZcGDak4FEHaTHaeYFzw?e=0BeE8t&download=1',
    ),

    # StyleGAN third-party.
    'stylegan_animeface512': dict(
        gan_type='stylegan',
        resolution=512,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EWDWflY6lBpGgX0CGQpd2Z4B5wTEVamTOA9JRYne7zdCvA?e=tOzgYA&download=1',
    ),
    'stylegan_animeportrait512': dict(
        gan_type='stylegan',
        resolution=512,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EXBvhTBi-v5NsnQtrxhFEKsBin4xg-Dud9Jr62AEwFTIxg?e=bMGK7r&download=1',
    ),
    'stylegan_artface512': dict(
        gan_type='stylegan',
        resolution=512,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/Eca0OiGqhyZMmoPbKahSBWQBWvcAH4q2CE3zdZJflp2jkQ?e=h4rWAm&download=1',
    ),

    # StyleGAN2 official.
    'stylegan2_ffhq1024': dict(
        gan_type='stylegan2',
        resolution=1024,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EX0DNWiBvl5FuOQTF4oMPBYBNSalcxTK0AbLwBn9Y3vfgg?e=Q0sZit&download=1',
    ),
    'stylegan2_church256': dict(
        gan_type='stylegan2',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EQzDtJUdQ4ROunMGn2sZouEBmNeFX4QWvxjermVE5cZvNA?e=tQ7r9r&download=1',
    ),
    'stylegan2_cat256': dict(
        gan_type='stylegan2',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EUKXeBwUUbZJr6kup7PW4ekBx2-vmTp8FjcGb10v8bgJxQ?e=nkerMF&download=1',
    ),
    'stylegan2_horse256': dict(
        gan_type='stylegan2',
        resolution=256,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EconoT6tb69OuAIqfXRtGlsBZz4vBx01UmmFO-JAS356Jg?e=bcSCC4&download=1',
    ),
    'stylegan2_car512': dict(
        gan_type='stylegan2',
        resolution=512,
        url='https://mycuhk-my.sharepoint.com/:u:/g/personal/1155082926_link_cuhk_edu_hk/EYSnUsxU8KJFuMHhZm-JLWoB0nHxdlbrLHNZ_Qkoe3b9LA?e=Ycjp5A&download=1',
    ),

    ############
    ############ StyleGANPORT
    ############
    'stylegan2_afhqdog512': dict(
        gan_type='stylegan2',
        resolution=512,
        url='http://eecs.qmul.ac.uk/~jo001/gan_checkpoints/stylegan2_afhqdog512.pth',
    ),
    'stylegan2_afhqcat512': dict(
        gan_type='stylegan2',
        resolution=512,
        url='http://eecs.qmul.ac.uk/~jo001/gan_checkpoints/stylegan2_afhqcat512.pth',
    ),
    'stylegan2_metfaces1024': dict(
        gan_type='stylegan2',
        resolution=1024,
        url='http://eecs.qmul.ac.uk/~jo001/gan_checkpoints/stylegan2_metfaces1024.pth',
    ),
    ############
    ############
    ############

}

# pylint: enable=line-too-long
