import sys


def get_network(arch, num_classes=100):
    """ return given network
    """
    print(arch, num_classes)
    if arch == 'resnet18':
        from ..models.resnet import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'vgg11_bn':
        from ..models.vgg import vgg
        net = vgg(num_classes=num_classes, arch=arch)
    elif arch == 'vgg19_bn':
        from ..models.vgg import vgg
        net = vgg(num_classes=num_classes, arch=arch)
    elif arch == 'convnext_t':
        from ..models.convnext import convnext_tiny
        net = convnext_tiny(num_classes=num_classes)
    elif arch == 'convnext_s':
        from ..models.convnext import convnext_small
        net = convnext_small(num_classes=num_classes)
    elif arch == 'mobilenetv3_small_50':
        from ..models.mobilenetv3 import mobilenetv3
        net = mobilenetv3(num_classes=num_classes, arch='mobilenetv3_small', width_mult=0.5)
    elif arch == 'mobilenetv3_large_100':
        from ..models.mobilenetv3 import mobilenetv3
        net = mobilenetv3(num_classes=num_classes, arch='mobilenetv3_large', width_mult=1.0)
    elif arch == 'hivit_tiny':
        from ..models.hivit import hivit_tiny
        net = hivit_tiny(num_classes=num_classes)
    elif arch == 'hivit_small':
        from ..models.hivit import hivit_small
        net = hivit_small(num_classes=num_classes)
    elif arch == 'hivit_base':
        from ..models.hivit import hivit_base
        net = hivit_base(num_classes=num_classes)
    # Not Supported
    else:
        print('the network name you have entered is not supported yet')
        sys.exit()
    return net
