import sys


def get_network(arch, num_classes=200):
    """ return given network
    """
    print(arch, num_classes)
    if arch == 'resnet18':
        from ..models.resnet import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'resnet34':
        from ..models.resnet import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'resnet50':
        from ..models.resnet import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'resnet152':
        from ..models.resnet import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'vgg11_bn':
        from ..models.vgg import vgg
        net = vgg(num_classes=num_classes, arch=arch)
    # Not Supported
    else:
        print('the network name you have entered is not supported yet')
        sys.exit()
    return net
