import sys


def get_network(arch, num_classes=200):
    """ return given network
    """
    print(arch, num_classes)
    if arch == 'resnet18':
        from ..models.resnet import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'resnet34':
        from ..models.resnet import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'resnet50':
        from ..models.resnet import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'resnet152':
        from ..models.resnet import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'convnext_t':
        from ..models.convnext import convnext_tiny
        net = convnext_tiny(num_classes=num_classes)
    elif arch == 'convnext_s':
        from ..models.convnext import convnext_small
        net = convnext_small(num_classes=num_classes)
    elif arch == 'atm_xt':
        from ..models.atm import ActivexTiny
        net = ActivexTiny(img_size=64, patch_size=4, num_classes=num_classes)
    elif arch == 'atmf_xt':
        from ..models.atmf import ActivexTiny
        net = ActivexTiny(img_size=64, patch_size=4, num_classes=num_classes)
    elif arch == 'atmf_t':
        from ..models.atmf import ActiveTiny
        net = ActiveTiny(img_size=64, patch_size=4, num_classes=num_classes)
    elif arch == 'atmf_b':
        from ..models.atmf import ActiveBase
        net = ActiveBase(img_size=64, patch_size=4, num_classes=num_classes)
    elif arch == 'mobilenetv3_small_50':
        from ..models.mobilenetv3 import mobilenetv3
        net = mobilenetv3(num_classes=num_classes, arch='mobilenetv3_small', width_mult=0.5)
    elif arch == 'mobilenetv3_small_100':
        from ..models.mobilenetv3 import mobilenetv3
        net = mobilenetv3(num_classes=num_classes, arch='mobilenetv3_small', width_mult=1.0)
    elif arch == 'mobilenetv3_large_100':
        from ..models.mobilenetv3 import mobilenetv3
        net = mobilenetv3(num_classes=num_classes, arch='mobilenetv3_large', width_mult=1.0)
    elif arch == 'vgg11_bn':
        from ..models.vgg import vgg
        net = vgg(num_classes=num_classes, arch=arch)
    elif arch == 'vgg16_bn':
        from ..models.vgg import vgg
        net = vgg(num_classes=num_classes, arch=arch)
    elif arch == 'vgg19_bn':
        from ..models.vgg import vgg
        net = vgg(num_classes=num_classes, arch=arch)
    elif arch == 'svgg19_bn':
        from ..models.svgg import vgg
        net = vgg(num_classes=num_classes, arch=arch)
    elif arch == 'hivit_tiny':
        from ..models.hivit import hivit_tiny
        net = hivit_tiny(num_classes=num_classes)
    elif arch == 'hivit_small':
        from ..models.hivit import hivit_small
        net = hivit_small(num_classes=num_classes)
    elif arch == 'hivit_base':
        from ..models.hivit import hivit_base
        net = hivit_base(num_classes=num_classes)
    elif arch in ['efficientvit_m0', 'efficientvit_m1', 'efficientvit_m2']:
        from ..models.efficientvit import efficientvit
        net = efficientvit(num_classes=num_classes, arch=arch)
    elif arch == 'resnetl18':
        from ..models.resnetl import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'resnets18':
        from ..models.resnets import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'resnetw18':
        from ..models.resnetw import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'resnetxw18':
        from ..models.resnetxw import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'resnett18':
        from ..models.resnett import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    elif arch == 'resnet318':
        from ..models.resnet3 import resnet
        net = resnet(num_classes=num_classes, arch=arch)
    # Not Supported
    else:
        print('the network name you have entered is not supported yet')
        sys.exit()
    return net
