import matplotlib.pyplot as plt
from scipy.interpolate import griddata
import numpy as np

x = [1, 1, 1, 1, 1, 0.1, 0.2, 0.4, 0.6, 0.8, 2, 3, 4, 5]
y = [0.1, 0.01, 0.001, 0.0001, 0.00001, 0.0001, 0.0005, 0.0006, 0.0008, 0.0008, 0.001, 0.002, 0.003, 0.004]
z = [48.10, 47.75, 47.82, 47.66, 48.22, 8.72, 29.53, 44.14, 46.46, 47.12, 50.73, 52.24, 53.25, 53.53]

x_log = np.log(x)
y_log = np.log(y)

fig = plt.figure()
ax = fig.add_subplot(111, projection='3d')

ax.scatter(x_log, y_log, z)
X, Y = np.meshgrid(x_log, y_log)
Z = griddata((x_log, y_log), z, (X, Y), method='linear')

surface = ax.plot_surface(X, Y, Z, cmap='viridis')

fig.colorbar(surface, shrink=0.5, aspect=10)


ax.set_xlabel('log(beta)')
ax.set_ylabel('log(snr weight)')
ax.set_zlabel('robsut acc')

plt.savefig('/home/verification/Unsupervised-Robust-Learning/TRADES/result_cifar_3d.png')
