from glob import glob
import os
import shutil
from tqdm import tqdm
import random

IMAGENET_PATH = '/workspace/data/datasets/imagenet/train/'
DST_PATH = '/workspace/data/datasets/imagenet16/'
SUBSET = 50

for file_name in glob('generalisation-humans-DNNs/16-class-ImageNet/image_names/*.txt'):
    class_label = file_name.split('/')[-1].split('.')[0]

    with open(file_name, 'r') as f:
        image_names = f.readlines()

    # shuffle for subsets
    random.shuffle(image_names)

    os.makedirs(os.path.join(DST_PATH, f'/{class_label}/'), exist_ok=True)
    for image_name in tqdm(image_names[:SUBSET]):
        image_name = image_name.strip()
        syn_id = image_name.split('_')[0]

        shutil.copy(os.path.join(IMAGENET_PATH, '/train/{syn_id}/{image_name}'), 
                    os.path.join(DST_PATH, f'/{class_label}/'))
