"""
Trains pure pediction emulators and neural-hybrid emulators (a neural network
correcting a coarse solver) for the 2D advection equation at high difficulty
(gamma_1=10.5).

Compares two kind of architectures: a local convolutional ResNet (with 10
receptive field, insufficient at this difficulty) and the global receptive field
(pseudo-spectral) FNO. Uses the default initial condition of up to (including)
the fifth mode, hence the FNO has enough active modes.

Considers pure prediction, and 10% and 50% correction in terms of a defective
solver (only performing a portion of the time step).

Training configuration is both one-step supervised training and five-step
supervised unrolled training.
"""
CONFIGS = [
    {
        "scenario": "diff_adv",
        "task": task,
        "net": net,
        "train": train,
        "start_seed": s,
        "num_seeds": 1,
        "num_spatial_dims": 2,
        "advection_gamma": advection_gamma,
        "coarse_proportion": coarse_proportion,
    }
    for s in range(20)
    for task, advection_gamma, coarse_proportion in [
        ("predict", 10.5, 0.0),
        ("correct;sequential", 10.5, 0.1),
        ("predict", 10.5 * 0.9, 0.0),  # Was not used in the paper in the end
        ("correct;sequential", 10.5, 0.5),
    ]
    for train in [
        "sup;1",
        "sup;5",
    ]
    for net in [
        "Res;26;5;relu",  # 61'179 params, 10 receptive field per direction
        "FNO;10;6;4;gelu",  # 57'787 params, inf receptive field per direction
    ]
]
