# Supplemental Material for "APEBench: A Benchmark for Autoregressive Neural Emulators of PDEs"


Dear Reviewer,

Thank you for taking a look at our supplemental material.

## Qualitative Rollouts

You can find qualitative rollouts of the emulators in the `Qualitative Rollouts.html` website which can be opened with a browser and organizes the video and resources in a more accessible manner.

## Source Code

The `apebench-paper` folder contains the scripts and postprocessing notebooks to
reproduce the experiments in the paper.

APEBench is designed modularly to allow for easy extension and modification.
Below, we outline the five individual Python package which will be released to
PyPI upon acceptance. You can view them via anonymous links.  The individual
packages come with their own `PyProject.toml` and can be installed simply by
`pip install .` if you download the source code from the respective links.

* [exponax](https://anonymous.4open.science/r/exponax-8E25) - ETDRK Solver Suite
* [pdequinox](https://anonymous.4open.science/r/pdequinox-B776) - Autoregressive Emulator Architectures
* [trainax](https://anonymous.4open.science/r/trainax-883C) - Unrolled Training Methodologies
* [vape](https://anonymous.4open.science/r/vape-346E) - Fast Web-GPU based Volume Rendering
* [apebench](https://anonymous.4open.science/r/apebench-EC1E)  - Main Package that ties everything together (not yet pip installable)

## Re-Running Experiments


Generally speaking, we advise creating a new conda environment. For the most
streamlined experience on Linux with a NVIDIA GPU with drivers allowing for CUDA
12, run the following commands

```
conda create -n apebench python=3.12 -y
conda activate apebench
pip install -U "jax[cuda12]"
pip install -r requirements.txt
```

Change into the `apebench-paper` directory

```
cd apebench-paper
```

You can ignore the Installation instructions in this README, this folder is
already set up correctly. The fastest experiment to reproduce are the results of
Figure 3(a) in the paper, which can be run with the following command (runtime
~5h for all seeds, ~1h for one batch of ten seeds, you can comment out
additional seeds in the script to reduce runtime):

```
python run.py experiments/adv_varying_difficulty_nonlin_emulators.py
```

Afterward, open the Jupyter notebook `apebench-paper/postprocessing/adv_varying_difficulty_nonlin_emulators/postprocessing_adv_varying_difficulty_nonlin_emulators.ipynb` to generate the plots.
