"""
Ablate the optimization configuration in terms of the total number of training
steps performed and the peak learning rate. The scheduler maintains a warmup
cosine learning rate curve with the peak (end of warmup) achieved after a fifth
of the total training steps.

Compares all major architecture classes in 1D across five scenarios.

Only full prediction at one-step supervised training is considered.
"""
CONFIGS = [
    {
        "scenario": scenario,
        "task": "predict",
        "net": net,
        "train": "one",
        "start_seed": s,
        "num_seeds": 10,
        "optim_config": f"adam;{num_training_steps};warmup_cosine;0.0;{peak_lr};{num_training_steps // 5}",
    }
    for s in [0, 10, 20, 30, 40]
    for net in [
        "Conv;34;10;relu",  # 31'757 params, 11 receptive field per direction
        "UNet;12;2;relu",  # 27'193 params, 29 receptive field per direction
        "Res;26;8;relu",  # 32'943 params, 16 receptive field per direction
        "FNO;12;18;4;gelu",  # 32'527 params, inf receptive field per direction
        "Dil;2;32;2;relu",  # 31'777 params, 20 receptive field per direction
    ]
    for num_training_steps in [
        5_000,
        10_000,
        20_000,
        40_000,
        80_000,
    ]
    for peak_lr in [
        1e-2,
        3e-3,
        1e-3,
        3e-4,
    ]
    for scenario in [
        "diff_adv",
        "diff_diff",
        "diff_burgers",
        "diff_kdv",
        "diff_ks",
    ]
]
