"""
Ablate the size of the network's parameter space by scaling the hidden channels
(=width). No modifications to the architecture's depth to not alter the
effective receptive field.

Compares all major architecture classes in 1D across five scenarios.

Only full prediction at one-step supervised training is considered.
"""
CONFIGS = [
    {
        "scenario": scenario,
        "task": "predict",
        "net": net,
        "train": "one",
        "start_seed": s,
        "num_seeds": 10,
    }
    for s in [0, 10, 20, 30, 40]
    for net in [
        # `hc_exp` = hidden channel exponent
        *[f"Conv;{2**hc_exp:03d};10;relu" for hc_exp in range(9 + 1)],
        *[f"UNet;{2**hc_exp:03d};2;relu" for hc_exp in range(6 + 1)],
        *[f"Res;{2**hc_exp:03d};8;relu" for hc_exp in range(9 + 1)],
        *[f"FNO;12;{2**hc_exp:03d};4;relu" for hc_exp in range(5 + 1)],
        *[f"Dil;2;{2**hc_exp:03d};2;relu" for hc_exp in range(8 + 1)],
    ]
    for scenario in [
        "diff_adv",
        "diff_diff",
        "diff_burgers",
        "diff_kdv",
        "diff_ks",
    ]
]
