## Zeroth-Order Optimization Finds Flat Minima (FlatZero)

The code is for reproducing all experiment results in the paper.


### Test Function

Code for Figures 1 and 4 is provided in the directory `./test_func` and requires the package `numpy`. Usage:
```bash
cd ./test_func
mkdir ./res
python run_toy.py
```
Results will be stored at `./test_func/res` as `json` files.


### Binary Classification with SVMs and Logistic Regression

Code for Figures 2 and 5 is provided in the directory `./svm_logreg` and requires the packages `numpy`, `scikit-learn`, and `wandb`. The datasets need to be already downloaded and exist at `./svm_logreg/data`. Usage:
```bash
cd ./svm_logreg
mkdir ./res_logreg
mkdir ./res_svm
nohup bash train_logreg.sh > logreg.out &
nohup bash train_svm.sh > svm.out &
```
Results will be stored at `./svm_logreg/res_logreg` and `./svm_logreg/res_svm` as `json` files.


### Fine-Tuning Language Models on Text Classification Tasks

Code for Figures 3 and 6 is provided in the directory `./roberta` and requires the packages `torch` and `transformers`. Usage:

1. Create the environment (replace `env_name` by any name)

```bash
cd ./roberta
conda env create -n env_name -f environment.yml
conda activate env_name
```

2. Prepare the data
```bash
cd ./data
bash prepare_datasets.sh
```

3. Run the examples

```bash
cd ..
nohup bash examples/flat-zo.sh > zo.out &
nohup bash examples/flat-gd.sh > gd.out &
```
Results will be stored at `./roberta/zo.out` and `./roberta/gd.out`.