# %%
import numpy as np
from skopt import gp_minimize
from skopt.space import Real
import torch
import transformer_lens.utils as utils
from functools import partial
import torch
from botorch.models import SingleTaskGP

from botorch.optim import optimize_acqf
from botorch.acquisition import qLogExpectedImprovement
from gpytorch.mlls import ExactMarginalLogLikelihood
import torch
from botorch.models import SingleTaskGP
from botorch.models.transforms import Normalize, Standardize
from botorch.fit import fit_gpytorch_mll
from gpytorch.mlls import ExactMarginalLogLikelihood
import pickle
from Utils.datasetUtil import *
from Utils.checkpointUtil import *
from Utils.intervention import *
from tqdm import tqdm

# %%

import argparse

parser = argparse.ArgumentParser(description='Train a model with RoPE')
parser.add_argument('--model', type=str, default='meta-llama/Meta-Llama-3-8B', help='The model to use')
parser.add_argument('--layer', type=int, nargs=2, default=[0, 32], help='The layer range to rotate')
parser.add_argument('--dataset', type=str, default='modified_arithmetic', help='The dataset to use')
parser.add_argument('--angle_0', type=str)
parser.add_argument('--angle_1', type=str)
arg = parser.parse_args()



# python3 trainRotation.py --model llama-3-8b --layer 0 32 --dataset modified_arithmetic
modelPath = arg.model
if(modelPath == 'llama-3-8b'):
    MODEL_PATH = 'meta-llama/Meta-Llama-3-8B'
L = arg.layer
datasetName = arg.dataset
H = 32
N = 64
num_L = L[-1] - L[0]
angle_0 = convert_to_float(arg.angle_0)
angle_1 = convert_to_float(arg.angle_1)
# breakpoint()
angles = [(angle_0) * torch.pi, (angle_1) * torch.pi]
# breakpoint()
# L = [0,32]
# H = 32
# N = 64
# num_L = L[-1] - L[0]
n_initial_points = 8  # Number of initial points
dtype = torch.float64
device = 'cuda' #cuda

# %%
# meta-llama/Llama-2-7b-hf
model, tokenizer = loadTransformerLensModel(MODEL_PATH)

# %%
model = model.to(device)

# %%
import torch
import numpy as np

import torch


# %%


# %%
bounds = torch.tensor([[angles[0]] * (num_L * H * N), [angles[1]] * (num_L * H * N)], dtype=dtype).to(device)
initial_points = (torch.rand((n_initial_points, bounds.size(1)), device=device) * (bounds[1] - bounds[0]) + bounds[0]).to(bounds.device)

dataset = createDataset(datasetName, model, tokenizer)

train_prompts = dataset['train_prompts']
train_labels = dataset['train_labels']
train_answer_tokens = dataset['train_answer_tokens']
test_prompts = dataset['test_prompts']
test_labels = dataset['test_labels']

import os
os.makedirs(f'TrainPrompts/{modelPath}/{datasetName}', exist_ok=True)
os.makedirs(f'TrainLabels/{modelPath}/{datasetName}', exist_ok=True)
os.makedirs(f'TestPrompts/{modelPath}/{datasetName}', exist_ok=True)
os.makedirs(f'TestLabels/{modelPath}/{datasetName}', exist_ok=True)
os.makedirs(f'answer_tokens/{modelPath}/{datasetName}', exist_ok=True)
os.makedirs(f'checkpoint/{modelPath}/{datasetName}', exist_ok=True)

fileName = f'{modelPath}/{datasetName}/layer_{L[0]}_{L[1]}_angle_{angles[0]}_{angles[1]}'
    # break

# %%
# prompt = prompts[0]

# %%


# %%
from jaxtyping import Float, Int
# %%
with open(f'TrainPrompts/{fileName}.pkl', 'wb') as f:    
    pickle.dump(train_prompts, f)
with open(f'TrainLabels/{fileName}.pkl', 'wb') as f:
    pickle.dump(train_labels, f)
with open(f'answer_tokens/{fileName}.pkl', 'wb') as f:
    pickle.dump(train_answer_tokens, f)
with open(f'TestPrompts/{fileName}.pkl', 'wb') as f:
    pickle.dump(test_prompts, f)
with open(f'TestLabels/{fileName}.pkl', 'wb') as f:
    pickle.dump(test_labels, f)
# breakpoint()
# %%
import torch
import pickle



checkpoint_path = f'checkpoint/{fileName}.pkl'

def objective(params):
    print(params.shape)
    # breakpoint()
    D = params.view(num_L, H, N)  # Ensure the tensor is reshaped correctly
    accuracy = 0
    count = 0
    prob = 0
    from tqdm import tqdm
    for prompt, label, answer_token in tqdm(zip(train_prompts, train_labels, train_answer_tokens), desc="Rotated Accuracy", total=len(train_prompts)):
        predicted_output, answer_token_prob = runRotatedModel(model, tokenizer, prompt, D, answer_token, L)
        if predicted_output.strip().lower() == label.strip().lower():
            accuracy += 1 
        count += 1
        prob += answer_token_prob

    avg_prob = prob / count
    print(f"Accuracy: {accuracy / count}")
    print(f"Answer token prob: {avg_prob}")
    return -torch.tensor(avg_prob, dtype=dtype)
# %%
try:
    train_X, train_Y, gp_state_dict, start_iteration = load_checkpoint(checkpoint_path)
    train_X = train_X.to('cpu')
    train_Y = train_Y.to('cpu')
    bounds = bounds.to('cpu')

    print(f"Resuming from iteration {start_iteration}")
    
    # Reconstruct the GP model
    gp = SingleTaskGP(train_X, train_Y, input_transform=Normalize(d=train_X.shape[-1]), outcome_transform=Standardize(m=1))
    gp.load_state_dict(gp_state_dict)
    mll = ExactMarginalLogLikelihood(gp.likelihood, gp)
    fit_gpytorch_mll(mll)
    
except FileNotFoundError:
    # No checkpoint exists, start from scratch
    train_X = initial_points
    train_Y = torch.tensor([objective(x) for x in train_X], dtype=dtype, device=device).unsqueeze(-1)
    gp = SingleTaskGP(train_X, train_Y, input_transform=Normalize(d=train_X.shape[-1]), outcome_transform=Standardize(m=1))
    mll = ExactMarginalLogLikelihood(gp.likelihood, gp)
    fit_gpytorch_mll(mll)
    start_iteration = 0

# Define the number of iterations
n_iterations = 150


# Optimization loop
from tqdm import tqdm
for iteration in tqdm(range(start_iteration, n_iterations)):

    EI = qLogExpectedImprovement(model=gp, best_f=train_Y.min())
    
    new_x, _ = optimize_acqf(
        acq_function=EI,
        bounds=bounds,
        q=1,
        num_restarts=20,
        raw_samples=1024,
    )
    new_y = objective(new_x)
    
    train_X = torch.cat([train_X, new_x])
    train_Y = torch.cat([
        train_Y.clone().detach().to(device).squeeze(-1), 
        new_y.clone().detach().to(device).unsqueeze(-1)
    ]).unsqueeze(-1)

    gp = SingleTaskGP(train_X, train_Y, input_transform=Normalize(d=train_X.shape[-1]), outcome_transform=Standardize(m=1))
    mll = ExactMarginalLogLikelihood(gp.likelihood, gp)
    fit_gpytorch_mll(mll)
    
    save_checkpoint(checkpoint_path, train_X, train_Y, gp.state_dict(), iteration + 1)
    del new_x, new_y
    print(f"Iteration {iteration + 1}/{n_iterations}, best observed value: {train_Y.min().item()}")
    # optimized_params = train_X[train_Y.argmin()].view(num_L, H, N)
    # torch.save(optimized_params, f'final_parameter/optimized_params{fileName}.pt')


