After installing the dependencies listed in the `requerment.txt` file, you can directly run the demo. Here are the steps:

1. Make sure you have installed the Python interpreter. You can download and install the latest version of Python from the official Python website (https://www.python.org).

2. Open a command line terminal and navigate to the directory containing the `requirement.txt` file.

3. Create a virtual environment (optional but recommended). A virtual environment helps to isolate the project's dependencies and avoid conflicts with other projects. You can create a virtual environment using the `venv` module. Run the following command to create a virtual environment:

   ````shell
   python -m venv myenv
   ```

   This will create a virtual environment named `myenv`.

4. Activate the virtual environment. Depending on your operating system, run one of the following commands to activate the virtual environment:

   - On Windows:
     ```shell
     myenv\Scripts\activate
     ```

   - On macOS/Linux:
     ```shell
     source myenv/bin/activate
     ```

5. Install the dependencies. Run the following command to install all the dependencies listed in the `requerment.txt` file:

   ````shell
   pip install -r requerment.txt
   ```

   This will automatically install all the required packages using the pip tool.

6. Once the installation is complete, you can directly run the demo. Depending on your specific case, the demo could be a Python script file, a module containing the main program, or any other form of executable file. Run the following command to launch the demo:

   ````shell
   python demo.py
   ```

By following these steps, installing all the dependencies, and running the demo directly, you should be able to successfully find outputs in './outputs'.
