import os
from glob import glob
import numpy as np
import json
import random
import ants
from tqdm import tqdm
import torch
from torch.utils.data import Dataset
from torch.multiprocessing import Pool
from scipy.ndimage import morphology
from .transforms import *


class Diffusion(Dataset):
    def __init__(self, dataroot, stage):
        super().__init__()
        print(dataroot)
        self.dataroot = dataroot
        self.phase = stage
        if self.phase == 'train':
            self.transform = get_train_transforms()
        elif self.phase == 'val':
            self.transform = get_test_transforms()
        elif self.phase == 'test':
            self.transform = get_test_transforms()

        self.dataset = glob(f'{self.dataroot}/{self.phase}/*/DTI/tensor/*')
        self.patient_list = [p.split('/')[-4] for p in self.dataset]

        print(f'{self.phase} dataset size - patient: {len(self.patient_list)}, volume: {len(self.dataset)}')

    def __getitem__(self, index):
        tensor_path = self.dataset[index]
        patient_dir = '/'.join(tensor_path.split('/')[:-3])
        tensor_direction = tensor_path.split('/')[-1].split('_')[1].split('.')[0]
        
        data_0_1000xyz_path = os.path.join(patient_dir, 'data_0_1000xyz.nii.gz')
        mask_path = os.path.join(patient_dir, 'mask.nii.gz')
        bvecs_0_1000xyz_path = os.path.join(patient_dir, 'bvecs_0_1000xyz.txt')
        minmaxv_path = os.path.join(patient_dir, 'minmaxv.npy')
        
        nifti_tensor = ants.image_read(tensor_path)
        nifti_b0_1000xyz = ants.image_read(data_0_1000xyz_path)
        nifti_mask = ants.image_read(mask_path)
        bvecs_0_1000xyz = np.loadtxt(bvecs_0_1000xyz_path)
        minmaxv = np.load(minmaxv_path)
        
        tensor = nifti_tensor.numpy()
        b0_1000xyz = nifti_b0_1000xyz.numpy()
        b0 = b0_1000xyz[..., 0]
        b1000x = b0_1000xyz[..., 1]
        b1000y = b0_1000xyz[..., 2]
        b1000z = b0_1000xyz[..., 3]
        mask = nifti_mask.numpy().astype(np.uint8)
        
        b1000xyz_dir = bvecs_0_1000xyz[1:]
        
        return self.transform({'tensor': tensor, 'tensor_direction': tensor_direction, 'b0': b0, 'b1000x': b1000x, 'b1000y': b1000y, 'b1000z': b1000z, 'mask': mask, 'b1000xyz_dir': b1000xyz_dir, 'minmaxv': minmaxv})
        
    def __len__(self):
        """Return the total number of images in the dataset."""
        return len(self.dataset)
