#!/usr/bin/env python
# coding: utf-8

# In[3]:


import numpy as np
import tensorflow as tf
import scipy
from tensorflow import keras
from tensorflow.keras import layers

from tensorflow.keras.applications.vgg16 import VGG16
from keras.preprocessing.image import load_img
from keras.preprocessing.image import img_to_array
from keras.applications.vgg16 import preprocess_input

import matplotlib.pyplot as plt
from scipy import stats

from tqdm.auto import tqdm


# ## Extracting features from VGG16

# In[4]:
def run():
    return_results = {}
    img_size = 224
    vgg16 = VGG16(weights='imagenet', include_top=True, pooling='max', input_shape = (img_size, img_size, 3))
    # vgg16.summary()


    # In[5]:


    op = vgg16.get_layer('fc2').output
    ip = vgg16.input

    basemodel = keras.Model(
        inputs=ip,
        outputs=op,
    )

    basemodel.trainable=False


    # In[6]:


    images = np.empty((50, img_size, img_size, 3))
    for i in range(50):
      image = load_img("data/" + str(i+1) +".jpg", target_size=(img_size, img_size))
      image = img_to_array(image)

      for j in range(img_size):
        for k in range(img_size):
          g = (image[j,k,0] + image[j,k,1] + image[j,k,2])/3
          image[j,k,0] = g
          image[j,k,1] = g
          image[j,k,2] = g

      images[i,:,:,:] = image

    images = preprocess_input(images)
    features = basemodel.predict(images, verbose=1)
    inputimages = features.reshape(50,-1)

    data = np.genfromtxt('data/bandw.csv', skip_header = 6, delimiter=',')
    humanpred = np.zeros((50,5))
    for i in range(50):
      for j in range(56):
        color = int(data[j, i]);
        humanpred[i, color] = humanpred[i, color]+1

    prob = humanpred/56

    outputprob = prob.reshape(250)

    prob_human = outputprob.reshape((50, 5))
    correct = np.genfromtxt('data/bandw.csv', skip_header = 1, skip_footer = 60, delimiter=',')
    human_pred = np.argmax(prob_human, axis=1)


    # ## Model

    # In[7]:


    def get_model(op_features=200):
      imageinputs = keras.Input(shape=(inputimages.shape[1]), name="imageinputs")
      dense = layers.Dense(op_features, name = "linearlayer", activation='relu')
      imageresults = dense(imageinputs)

      result = tf.keras.layers.Dense(5, activation='softmax')(imageresults)

      model = keras.Model(
          inputs=imageinputs,
          outputs=result,
      )

      model.compile(loss = 'sparse_categorical_crossentropy', optimizer = tf.keras.optimizers.Adam(lr=0.001), metrics = ['accuracy'])

      return model


    # In[8]:


    # Human Pred

    acc_model = []
    model_wrt_human = []

    for i in tqdm(range(50)):
      pred = np.zeros(50) #This will contain the final prediction for each of the loop. Total 5 subset of validation 5 each.

      # 5-fold cross validation
      for vs in [0, 10, 20, 30, 40]:
        ve = vs + 10

        model = get_model(op_features=75)

        history = model.fit(inputimages[[*range(vs)] + [*range(ve, 50)]],
            human_pred[[*range(vs)] + [*range(ve, 50)]],
            epochs=15,
            batch_size=10,
            shuffle=True,
            verbose=0,
            validation_data=(inputimages[vs:ve], human_pred[vs:ve])
        )

        output = model.predict_step(inputimages)

        pred[vs:ve] = np.argmax(output[vs:ve], axis=1)
        # print(np.sum(pred[vs:ve]==correct[vs:ve])/pred[vs:ve].shape[0])

      acc_model.append(np.sum(pred == correct)*100/pred.shape[0])
      acc_human = np.sum(human_pred == correct)*100/pred.shape[0]
      model_wrt_human.append(np.sum(pred == human_pred)*100/pred.shape[0])

    acc_model_mean = np.mean(acc_model)
    acc_model_std = np.std(acc_model)
    model_wrt_human_mean = np.mean(model_wrt_human)
    model_wrt_human_std = np.std(model_wrt_human)

    return_results['standard_human_acc_actual_mean'] = acc_model_mean
    return_results['standard_human_acc_actual_std'] = acc_model_std
    return_results['standard_human_acc_actual_max'] = np.max(acc_model)
    return_results['standard_human_acc_actual_min'] = np.min(acc_model)

    return_results['standard_human_acc_human_mean'] = model_wrt_human_mean
    return_results['standard_human_acc_human_std'] = model_wrt_human_std
    return_results['standard_human_acc_actual_max'] = np.max(model_wrt_human)
    return_results['standard_human_acc_actual_min'] = np.min(model_wrt_human)

    # print("Actual:", acc_model_mean, acc_model_std)
    # print("wrt Human:", model_wrt_human_mean, model_wrt_human_std)
    #
    #
    # # In[9]:
    #
    #
    # np.max(acc_model), np.max(model_wrt_human)
    #
    #
    # # In[10]:
    #
    #
    # np.min(acc_model), np.min(model_wrt_human)


    # In[11]:


    # Actual Labels

    acc_model = []
    model_wrt_human = []

    for i in tqdm(range(50)):
      pred = np.zeros(50) #This will contain the final prediction for each of the loop. Total 5 subset of validation 5 each.

      # 5-fold cross validation
      for vs in [0, 10, 20, 30, 40]:
        ve = vs + 10

        model = get_model(op_features=75)

        history = model.fit(inputimages[[*range(vs)] + [*range(ve, 50)]],
            correct[[*range(vs)] + [*range(ve, 50)]],
            epochs=15,
            batch_size=10,
            shuffle=True,
            verbose=0,
        )

        output = model.predict_step(inputimages)

        pred[vs:ve] = np.argmax(output[vs:ve], axis=1)

      acc_model.append(np.sum(pred == correct)*2)
      acc_human = np.sum(human_pred == correct)*2
      model_wrt_human.append(np.sum(pred == human_pred)*2)

    acc_model_mean = np.mean(acc_model)
    acc_model_std = np.std(acc_model)
    model_wrt_human_mean = np.mean(model_wrt_human)
    model_wrt_human_std = np.std(model_wrt_human)

    return_results['standard_actual_acc_actual_mean'] = acc_model_mean
    return_results['standard_actual_acc_actual_std'] = acc_model_std
    return_results['standard_actual_acc_actual_max'] = np.max(acc_model)
    return_results['standard_actual_acc_actual_min'] = np.min(acc_model)

    return_results['standard_actual_acc_human_mean'] = model_wrt_human_mean
    return_results['standard_actual_acc_human_std'] = model_wrt_human_std
    return_results['standard_actual_acc_actual_max'] = np.max(model_wrt_human)
    return_results['standard_actual_acc_actual_min'] = np.min(model_wrt_human)

    # print("Actual:", acc_model_mean, acc_model_std)
    # print("wrt Human:", model_wrt_human_mean, model_wrt_human_std)


    # In[12]:


    # np.max(acc_model), np.max(model_wrt_human)


    # In[13]:


    # np.min(acc_model), np.min(model_wrt_human)


    # In[ ]:

    return return_results
