
# Abstract Counterfactuals 

This repository contains the methods and experiments for *Abstract Counterfactuals for Language Model Agents*.

## Installation 
We recommend using a virtual environment with `venv`. 
The basic dependencies for this environment can be installed using the provided `requirements.txt` file. 

Our code builds upon forked code from the repositories of previous research in language model counterfactuals. 
To maintain anonymity, we have included anonymised versions of these forks in the `forks` directory. 
These must be installed locally, using `pip install .` (in the root folder of the respective forked repos). 

We use the following environment variables (either in the shell, or provided in a `.env` file in the root of the project)

```
MACHIAVELLI_GAME_DATA_PATH=
BIOS_DATA_PATH=
MODEL_DATA_PATH=
CLEARML_PROJECT_NAME=
GOEMOTIONS_DATA_PATH=
```

We track the experimenst using `clear-ml` (this can be disabled from script arguments). 

## Main methods and experiments. 

The main methods are implemented in the `abstract_cf` package, with specific module for machiavelli (`machiavelli.py`) and a subpackage for text generation tasks `text_generation/`. 

Supervised abstractions can be trained using the module `abstract_cf.text_generation.learned_abstraction`. 

We sample subsets of the full datasets using `experiment_helper_scripts/sample_dataset.py`, which also uploads the subsets to the `clear-ml` server. 
Subsequent scripts using the datasets fetch them from `clearml`. 

The scripts used to finally run the full set of text generation experiments are `experiment_helper_scripts/acf_experiments.sh` and `experiment_helper_scripts/tlfc_experiments.sh`for abstract counterfactuals and token level counterfactuals respectively. 

For convenience, the scripts use configuration files for the various interventions, which are located in `intervention_configs/`. 


Finally, analysis of the results is present in `explore/machiavelli_abstract_cf.ipynb` and `explore/text_generation_analysis.ipynb` for Machiavelli and text generation respectively. 
Before using text generation analysis notebook, the experiment data must be fetched and post-processed, using the `experiment_data_post_processing.ipynb` notebook. 
