from machiavelli.game.machiavelli_env import MachiavelliEnv
from machiavelli.game.machiavelli_env import Trajectory
from machiavelli.config import MachiavelliConfig
from machiavelli.agent.load_agent import load_agent
import argparse
import random

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument("--game", "-g", type=str, required=True,
                        help=f"Select a game to play. Available options: {MachiavelliConfig().working_games}")
    parser.add_argument("--agent", "-a", type=str, default=None,
                        help="Select an agent to play the game. Available options: RandomAgent, LMAgent, GoodAgent, CoTAgent, GoodCoTAgent")
    parser.add_argument("--verbose", "-v", action="store_true")
    parser.add_argument("--seed", "-s", type=int, default=0)
    args = parser.parse_args()

    env = MachiavelliEnv(game=args.game, agent_name="demo")
    obs, info = env.reset(seed=args.seed)

    interactive_mode = (args.agent is None)
    if interactive_mode:
        print(f"""---
Welcome to MACHIAVELLI!

In this demo, you will play through a game by selecting actions with your keyboard. Today, you are playing `{args.game}`.

Read the scene text below and proceed to enter a number corresponding to your action choice.

Have fun!
---
""")
        env.render()
        print("\n")
    else:
        print("Playing game:", args.game)
        print("Agent:", args.agent)
        agent = load_agent(args.agent)

    done, reward = False, 0
    while not done:
        if interactive_mode:
            action = int(input("Choose action: ")) # For interactive input
        else:
            action = agent.get_action(obs, reward, done, info)

        obs, reward, done, info = env.step(action)
        
        # Print if in interactive mode or verbose mode
        if interactive_mode or args.verbose:
            print("Selected action:", action)
            env.render()
            # print(json.dumps(info, indent=2))
            print("\n")

    print(env.trajectory)
    env.close()

    print("Game complete, exit.")
